{*
* 2007-2022 ETS-Soft
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses.
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs, please contact us for extra customization service at an affordable price
*
*  @author ETS-Soft <etssoft.jsc@gmail.com>
*  @copyright  2007-2022 ETS-Soft
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of ETS-Soft
*}

{if isset($fields_list) && $fields_list}
    {assign var="concat" value="{if $link|strpos:'?' > 0}&{else}?{/if}"}
    <div class="ets-hd-helper-list-{$table|escape:'html':'UTF-8'}">
        <form id="form-{$table|escape:'html':'UTF-8'}" action="{$link nofilter}" enctype="multipart/form-data"
              method="post" novalidate>
            <div class="panel  col-lg-12">
                <div class="panel-heading">
                    {$title|escape:'html':'UTF-8'}
                    <span class="badge">{$total_records|intval}</span>
                </div>
                <div class="table-responsive-row clearfix">
                    <table class="table">
                        <thead>
                        <tr class="nodrag nodrop">
                            {foreach from=$fields_list key='id' item='field'}
                                <th{if isset($field.class) && $field.class} class="{$field.class|escape:'html':'UTF-8'}"{/if}>
										<span class="title_box">
											{$field.label|escape:'html':'UTF-8'}
                                            {if !isset($field.orderby) || $field.orderby}
                                                <a class="{if $current_sort_by|trim == $id|cat:'.desc'}active{/if}"
                                                   href="{$link|cat:$concat|cat:'sort_by='|cat:$id|cat:'.desc' nofilter}">
													<i class="ets_icon">
                                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1408 704q0 26-19 45l-448 448q-19 19-45 19t-45-19l-448-448q-19-19-19-45t19-45 45-19h896q26 0 45 19t19 45z"/></svg>
                                                    </i>
												</a>
                                                <a class="{if $current_sort_by|trim == $id|cat:'.asc'}active{/if}"
                                                   href="{$link|cat:$concat|cat:'sort_by='|cat:$id|cat:'.asc' nofilter}">
													<i class="ets_icon">
                                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1408 1216q0 26-19 45t-45 19h-896q-26 0-45-19t-19-45 19-45l448-448q19-19 45-19t45 19l448 448q19 19 19 45z"/></svg>
                                                    </i>
												</a>
                                            {/if}
										</span>
                                </th>
                            {/foreach}
                            <th></th>
                        </tr>
                        {if $search_field && (!empty($filter) || isset($list) && $list|count > 0)}
                            <tr class="nodrag nodrop filter row_hover">
                                {assign var='search_field' value=0}
                                {foreach from=$fields_list key='key' item='field'}
                                    <th{if isset($field.class) && $field.class} class="{$field.class|escape:'html':'UTF-8'}"{/if}>
                                        {if !isset($field.search) || $field.search}
                                            {if $field.type == 'date' || $field.type == 'datetime'}
                                                <div class="date_range row">
                                                    <div class="input-group fixed-width-md center">
                                                        <input type="text"
                                                               class="filter datepicker date-input form-control"
                                                               name="{$table|escape:'html':'UTF-8'}_{$field.name|escape:'html':'UTF-8'}[0]"
                                                               placeholder="{l s='From' mod='ets_helpdesk'}"{if !empty($filter.$key.values.from)} value="{$filter.$key.values.from|escape:'html':'UTF-8'}" {/if} />
                                                        <span class="input-group-addon">
																<i class="ets_svg_fill_gray">
																	<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                                                         xmlns="http://www.w3.org/2000/svg"><path
                                                                                d="M192 1664h288v-288h-288v288zm352 0h320v-288h-320v288zm-352-352h288v-320h-288v320zm352 0h320v-320h-320v320zm-352-384h288v-288h-288v288zm736 736h320v-288h-320v288zm-384-736h320v-288h-320v288zm768 736h288v-288h-288v288zm-384-352h320v-320h-320v320zm-352-864v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm736 864h288v-320h-288v320zm-384-384h320v-288h-320v288zm384 0h288v-288h-288v288zm32-480v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm384-64v1280q0 52-38 90t-90 38h-1408q-52 0-90-38t-38-90v-1280q0-52 38-90t90-38h128v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h384v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h128q52 0 90 38t38 90z"/></svg>
																</i>
															</span>
                                                    </div>
                                                    <div class="input-group fixed-width-md center">
                                                        <input type="text"
                                                               class="filter datepicker date-input form-control"
                                                               name="{$table|escape:'html':'UTF-8'}_{$field.name|escape:'html':'UTF-8'}[1]"
                                                               placeholder="{l s='To' mod='ets_helpdesk'}"{if !empty($filter.$key.values.to)} value="{$filter.$key.values.to|escape:'html':'UTF-8'}" {/if} />
                                                        <span class="input-group-addon">
																<i class="ets_svg_fill_gray">
																	<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                                                         xmlns="http://www.w3.org/2000/svg"><path
                                                                                d="M192 1664h288v-288h-288v288zm352 0h320v-288h-320v288zm-352-352h288v-320h-288v320zm352 0h320v-320h-320v320zm-352-384h288v-288h-288v288zm736 736h320v-288h-320v288zm-384-736h320v-288h-320v288zm768 736h288v-288h-288v288zm-384-352h320v-320h-320v320zm-352-864v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm736 864h288v-320h-288v320zm-384-384h320v-288h-320v288zm384 0h288v-288h-288v288zm32-480v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm384-64v1280q0 52-38 90t-90 38h-1408q-52 0-90-38t-38-90v-1280q0-52 38-90t90-38h128v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h384v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h128q52 0 90 38t38 90z"/></svg>
																</i>
															</span>
                                                    </div>
                                                </div>
                                            {elseif $field.type == 'select' || $field.type == 'radio'}
                                                <select class="select"
                                                        name="{$table|escape:'html':'UTF-8'}_{$field.name|escape:'html':'UTF-8'}">
                                                    <option value="">--</option>
                                                    {if isset($field.list) && is_array($field.list) && $field.list|count > 0}
                                                        {foreach from=$field.list item='list'}
                                                            <option value="{$list.id|escape:'html':'UTF-8'}"{if isset($filter.$key.value) && $filter.$key.value == $list.id} selected{/if}>{$list.name|escape:'html':'UTF-8'}</option>
                                                        {/foreach}
                                                    {/if}
                                                </select>
                                            {else}
                                                <input type="text" class="filter"
                                                       name="{$table|escape:'html':'UTF-8'}_{$field.name|escape:'html':'UTF-8'}"{if isset($filter.$key.value)} value="{$filter.$key.value|escape:'html':'UTF-8'}" {/if}>
                                            {/if}
                                        {/if}
                                    </th>
                                {/foreach}
                                <th class="actions">
										<span class="pull-right">
											<button type="submit" id="submitFilterButton{$table|escape:'html':'UTF-8'}"
                                                    name="submitFilter{$table|escape:'html':'UTF-8'}"
                                                    class="btn btn-default"
                                                    data-list-id="{$table|escape:'html':'UTF-8'}"><i
                                                        class="icon-search">
                                                    <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1216 832q0-185-131.5-316.5t-316.5-131.5-316.5 131.5-131.5 316.5 131.5 316.5 316.5 131.5 316.5-131.5 131.5-316.5zm512 832q0 52-38 90t-90 38q-54 0-90-38l-343-342q-179 124-399 124-143 0-273.5-55.5t-225-150-150-225-55.5-273.5 55.5-273.5 150-225 225-150 273.5-55.5 273.5 55.5 225 150 150 225 55.5 273.5q0 220-124 399l343 343q37 37 37 90z"/></svg>
                                                </i> {l s='Search' mod='ets_helpdesk'}</button>
											{if isset($filter) && $filter}
                                                <button type="submit" name="submitReset{$table|escape:'html':'UTF-8'}" class="btn btn-warning">
                                                    <i class="ets_icon">
                                                        <svg class="w_15 h_14" width="15" height="14" viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M960 1408l336-384h-768l-336 384h768zm1013-1077q15 34 9.5 71.5t-30.5 65.5l-896 1024q-38 44-96 44h-768q-38 0-69.5-20.5t-47.5-54.5q-15-34-9.5-71.5t30.5-65.5l896-1024q38-44 96-44h768q38 0 69.5 20.5t47.5 54.5z"/></svg>
                                                    </i> {l s='Reset' mod='ets_helpdesk'}</button>
                                            {/if}
										</span>
                                </th>
                            </tr>
                        {/if}
                        </thead>
                        <tbody>
                        {if isset($list) && $list}
                            {assign var="ik" value=1}
                            {foreach from=$list item='item'}
                                <tr class="{if $ik%2 != 0}odd{/if}">
                                    {foreach from=$fields_list item='field'}
                                        <td{if isset($field.class) && $field.class} class="{$field.class|escape:'html':'UTF-8'}"{/if}>
                                            {if isset($item[$field.name]) && trim($item[$field.name]) !== ''}
                                                {assign var='link_ref' value=isset($field.link_ref_field) && $field.link_ref_field|trim !== '' && isset($item[$field.link_ref_field]) && $item[$field.link_ref_field]}
                                                {if $link_ref}
                                                    <a href="{$item[$field.link_ref_field] nofilter}" target="_blank">
                                                {/if}
                                                {if isset($field.product_display) && $field.product_display && isset($item.product_image) && isset($item.product_link)}
                                                    <a href="{$item.product_link nofilter}" title="{$item.product|escape:'html':'UTF-8'}">
                                                        <img src="{$item.product_image nofilter}" width="50px"/>
                                                    </a>
                                                {elseif $field.type == 'select' || $field.type == 'radio'}
                                                    {if isset($field.list) && is_array($field.list) && $field.list|count > 0}
                                                        {foreach from=$field.list item='list'}
                                                            {if $item[$field.name] == $list.id}
                                                                <span class="{$field.name|escape:'html':'UTF-8'}_{$list.id|lower|escape:'html':'UTF-8'}">{if isset($list.icon) && $list.icon}{$list.icon nofilter}{else}{$list.name|escape:'html':'UTF-8'}{/if}</span>
                                                            {/if}
                                                            {foreachelse}--{/foreach}
                                                    {/if}
                                                {elseif $field.type == 'order_status'}
                                                    <span class="order_status" style="background-color: {$item[$field.name|cat:'_color']|escape:'html':'UTF-8'}; color: white;">{$item[$field.name]|escape:'html':'UTF-8'}</span>
                                                {elseif $field.type == 'status'}
                                                    {if $item[$field.name]}
                                                        <span class="badge {if isset($item.badge_success)}badge-success{elseif isset($item.badge_danger)}badge-danger{/if}">{$item[$field.name]|escape:'html':'UTF-8'}</span>
                                                    {else}
                                                        --
                                                    {/if}
                                                {elseif $field.type == 'image'}
                                                    {if isset($item.product_link) && $item.product_link}
                                                        <a  href="{$item.product_link|escape:'html':'UTF-8'}" target="_blank">
                                                    {/if}
                                                    <img src="{$item[$field.name] nofilter}"{if isset($field.width) && $field.width} width="{$field.width|intval}"{/if}/>
                                                    {if isset($item.product_link) && $item.product_link}
                                                        </a>
                                                    {/if}
                                                {elseif $field.type == 'file'}
                                                    <a href="{$item[$field.name|cat:'_link_download'] nofilter}">{$item[$field.name]|escape:'html':'UTF-8'}</a>
                                                {elseif $field.type == 'date' || $field.type == 'datetime'}
                                                    <span>{dateFormat date=$item[$field.name] full=$field.type|trim !== 'date'}</span>
                                                {elseif isset($field.truncate) && $field.truncate > 0}
                                                    {$item[$field.name]|truncate:"{$field.truncate}":'...'|escape:'html':'UTF-8'}
                                                {else}
                                                    {$item[$field.name]|escape:'html':'UTF-8'}
                                                {/if}
                                                {if $link_ref}
                                                    </a>
                                                {/if}
                                                {if isset($field.fields) && is_array($field.fields) && $field.fields|count > 0}
                                                    <div class="ets_hd_fields">
                                                        {foreach from=$field.fields item='column'}
                                                            {if isset($item[$column.name]) && $item[$column.name]}
                                                                {if isset($column.label)}
                                                                    <span>{$column.label|escape:'html':'UTF-8'}:</span>{/if}
                                                                {if $column.type =='url'}
                                                                    <a href="{$item[$column.name] nofilter}"
                                                                       target="_blank">{$item[$column.name] nofilter}</a>
                                                                {else}{$item[$column.name]|escape:'html':'UTF-8'}{/if}
                                                            {/if}
                                                        {/foreach}
                                                    </div>
                                                {/if}
                                            {else}--{/if}
                                        </td>
                                    {/foreach}
                                </tr>
                            {/foreach}
                        {else}
                            <tr>
                                <td colspan="{math equation="a+b" a=$fields_list|count b=2}">
                                    <p class="no_data">{l s='No item' mod='ets_helpdesk'}</p>
                                </td>
                            </tr>
                        {/if}
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
{/if}

{if !empty($show_footer_btn)}
    <div class="ets_hd_pagination_footer {$table|escape:'html':'UTF-8'}">
        {if !empty($list_per_pages)}
            <div class="pagination">
                {l s='Display' mod='ets_helpdesk'}
                <button type="button" class="btn btn-default dropdown-toggle"
                        data-toggle="dropdown">{$current_per_page|intval}<i class="ets_icon">
                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1408 704q0 26-19 45l-448 448q-19 19-45 19t-45-19l-448-448q-19-19-19-45t19-45 45-19h896q26 0 45 19t19 45z"/></svg>
                    </i></button>
                <ul class="dropdown-menu">
                    {foreach from=$list_per_pages key='n' item='item_link'}
                        <li>
                            <a href="{if !empty($item_link)}{$item_link nofilter}{else}javascript:void(0);{/if}"
                               class="pagination-items-page" data-items="{$n|intval}">{$n|intval}</a>
                        </li>
                    {/foreach}
                </ul>
                / {$total_records|intval} {l s='result(s)' mod='ets_helpdesk'}
            </div>
        {/if}
        {if !empty($paginates) && $paginates|count > 3}
            <ul class="pagination pull-right">
                {foreach from=$paginates item='item'}
                    <li class="{$item.class|escape:'html':'UTF-8'}">
                        <a href="{if !empty($item.link)}{$item.link nofilter}{else}javascript:void(0);{/if}"
                           class="pagination-link">
                            {if !empty($item.icon)}
                                <i class="ets_svg_fill_gray lh_16">
                                    {if $item.icon == 'angle-left'}
                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1203 544q0 13-10 23l-393 393 393 393q10 10 10 23t-10 23l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23z"/>
                                        </svg>
                                    {elseif $item.icon == 'angle-double-left'}
                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1011 1376q0 13-10 23l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23zm384 0q0 13-10 23l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23z"/>
                                        </svg>
                                    {elseif $item.icon == 'angle-right'}
                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1171 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z"/>
                                        </svg>
                                    {elseif $item.icon == 'angle-double-right'}
                                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M979 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23zm384 0q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z"/>
                                        </svg>
                                    {/if}
                                </i>
                            {/if}
                            {if !empty($item.title)}{$item.title|escape:'html':'UTF-8'}{/if}
                        </a>
                    </li>
                {/foreach}
            </ul>
        {/if}
    </div>
{/if}