{*
* 2007-2022 ETS-Soft
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses.
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs, please contact us for extra customization service at an affordable price
*
*  @author ETS-Soft <etssoft.jsc@gmail.com>
*  @copyright  2007-2022 ETS-Soft
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of ETS-Soft
*}

{if isset($list_ticket_link) && $list_ticket_link|trim !== '' && !(isset($errors) && $errors)}
	<p class="ets_hd_alert_success alert alert-success">
        <button class="close" type="button" data-dismiss="alert">×</button>
        {l s='You have submitted a ticket successfully' mod='ets_helpdesk'} 
        <a href="{$list_ticket_link nofilter}">{l s='View ticket' mod='ets_helpdesk'}</a>
    </p>
{/if}
{if isset($errors) && $errors}
	<div class="ets_hd_alert_danger alert alert-danger">
        <button class="close" type="button" data-dismiss="alert">×</button>
		<ul class="ets_hd_errors_ul">
			{foreach from=$errors item='error'}
				<li>{$error|escape:'html':'UTF-8'}</li>
			{/foreach}
		</ul>
	</div>
{/if}
{if isset($fieldset) && is_array($fieldset) && $fieldset|count > 0}
	<form id="{if isset($table)}{$table|escape:'html':'UTF-8'}{else}ets_hd_config{/if}_form" class="defaultForm form-horizontal{if isset($reCAPTCHA) && $reCAPTCHA} form-g-recaptcha{/if}" action="{if isset($action) && $action|trim !== ''}{$action nofilter}{/if}" method="post" enctype="multipart/form-data" novalidate>
		{if isset($fieldset.form.submit)}
		<input type="hidden" name="{$fieldset.form.submit.name|escape:'html':'UTF-8'}" value="1">
		{/if}
		{if isset($identity) && $identity|trim !== '' && isset($id_object)}
			<input type="hidden" name="{$identity|escape:'html':'UTF-8'}" value="{$id_object|intval}">
		{/if}
		<div id="fieldset_0" class="panel">
			{if isset($fieldset.form) && $fieldset.form}
				{assign var='form' value=$fieldset.form}
				{foreach $form as $key => $field}
					{if $key == 'legend'}
						<div class="panel-heading">
							{if isset($field.title)}{$field.title|escape:'html':'UTF-8'}{/if}
						</div>
					{/if}
				{/foreach}
				{if isset($configs) && $configs && isset($table) && $table|trim == 'ets_hd_ticket'}
					<p class="ets-hd-ticket-description">
						{if !$is_staff && isset($configs.ETS_HD_TICKET_DESCRIPTION) && $configs.ETS_HD_TICKET_DESCRIPTION|trim !== ''}
							{$configs.ETS_HD_TICKET_DESCRIPTION nofilter}
						{elseif $is_staff && isset($configs.ETS_HD_STAFF_DESCRIPTION) && $configs.ETS_HD_STAFF_DESCRIPTION|trim !== ''}
							{$configs.ETS_HD_STAFF_DESCRIPTION nofilter}
						{/if}
					</p>
				{/if}
                {foreach $form as $key => $field}
	                {if $key == 'description' && $field}
		                <div class="alert alert-info">{$field nofilter}</div>
                    {elseif $key == 'warning' && $field}
		                <div class="alert alert-warning">{$field nofilter}</div>
                    {elseif $key == 'success' && $field}
		                <div class="alert alert-success">{$field nofilter}</div>
                    {elseif $key == 'error' && $field}
		                <div class="alert alert-danger">{$field nofilter}</div>
					{elseif $key == 'input'}
		                <div class="form-wrapper">
                            {if is_array($field) && $field|count}
                                {foreach $field as $input}
                                    {if $input.type == 'hidden' && (!isset($input.search) || !$input.search)}
	                                    <input type="hidden" name="{$input.name|escape:'html':'UTF-8'}" id="{$input.name|escape:'html':'UTF-8'}" value="{if isset($fields_value[$input.name])}{$fields_value[$input.name]|escape:'html':'UTF-8'}{/if}" />
	                                {else}
				                        <div class="form-group">
	                                        {if isset($input.label)}
						                        <label class="control-label col-lg-3{if isset($input.required) && $input.required} required{/if}">
	                                                {$input.label|escape:'html':'UTF-8'}
						                        </label>
	                                        {/if}
					                        <div class="col-lg-9{if !isset($input.label)} col-lg-offset-3{/if}">
                                                <div class="ets_hd_group_max">
	                                            {if $input.name|trim == 'id_customer' && isset($input.search) && $input.search}

														<div class="ets_hd_customer_search{if isset($input.customer) && is_array($input.customer) && $input.customer|count} active{/if}">
															{if isset($input.customer) && is_array($input.customer) && $input.customer|count}
																<div class="ets_hd_customer_item" data-id="{$input.customer.id|intval}">{$input.customer.name|escape:'html':'UTF-8'} ({$input.customer.email|escape:'html':'UTF-8'}) <span class="remove_ctm lh_16"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span></div>
															{/if}
														</div>
														<div class="input-group">
															<input type="text" id="search_customer_id" name="search_customer_id"{if isset($input.placeholder)} placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if} autocomplete="off">
															<span class="input-group-addon">
																<i class="ets_svg lh_16">
																	<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1216 832q0-185-131.5-316.5t-316.5-131.5-316.5 131.5-131.5 316.5 131.5 316.5 316.5 131.5 316.5-131.5 131.5-316.5zm512 832q0 52-38 90t-90 38q-54 0-90-38l-343-342q-179 124-399 124-143 0-273.5-55.5t-225-150-150-225-55.5-273.5 55.5-273.5 150-225 225-150 273.5-55.5 273.5 55.5 225 150 150 225 55.5 273.5q0 220-124 399l343 343q37 37 37 90z"/></svg>
																</i>
															</span>
														</div>
														<input type="hidden" id="id_customer" name="id_customer" value="{if isset($fields_value[$input.name]) && $fields_value[$input.name] > 0}{$fields_value[$input.name]|escape:'html':'UTF-8'}{/if}"/>

	                                            {elseif $input.name|trim == 'id_product' && isset($input.search) && $input.search}

														<div class="ets_hd_product_search{if isset($input.product) && is_array($input.product) && $input.product|count} active{/if}{if isset($product_ref) && $product_ref} product_ref{/if}">
															{if isset($input.product) && is_array($input.product) && $input.product|count}
																<div class="ets_hd_product_item" data-id="{$input.product.id|intval}"><img src="{$input.product.cover nofilter}" title="{$input.product.name|escape:'html':'UTF-8'}" width="64">{$input.product.name|escape:'html':'UTF-8'}<span class="remove_ctm lh_16"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span></div>
															{/if}
														</div>
														<div class="input-group">
															<input type="text" id="search_product" name="search_product"{if isset($input.placeholder)} placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if} autocomplete="off">
															<span class="input-group-addon">
																<i class="ets_svg lh_16">
																	<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1216 832q0-185-131.5-316.5t-316.5-131.5-316.5 131.5-131.5 316.5 131.5 316.5 316.5 131.5 316.5-131.5 131.5-316.5zm512 832q0 52-38 90t-90 38q-54 0-90-38l-343-342q-179 124-399 124-143 0-273.5-55.5t-225-150-150-225-55.5-273.5 55.5-273.5 150-225 225-150 273.5-55.5 273.5 55.5 225 150 150 225 55.5 273.5q0 220-124 399l343 343q37 37 37 90z"/></svg>
																</i>
															</span>
														</div>
														<input type="hidden" id="id_product" name="id_product" value="{if isset($fields_value[$input.name]) && $fields_value[$input.name] > 0}{$fields_value[$input.name]|escape:'html':'UTF-8'}{/if}">

												{elseif $input.type == 'text'}

														{if isset($fields_value[$input.name])}{assign var='value_text' value=$fields_value[$input.name]}{else}{assign var='value_text' value=''}{/if}
														<input type="text"
															   name="{$input.name|escape:'html':'UTF-8'}"
															   id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}"
															   value="{$value_text|escape:'html':'UTF-8'}"
															   class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}"
																{if isset($input.required) && $input.required } required="required" {/if}
																{if isset($input.placeholder) && $input.placeholder } placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if}
																{if isset($input.maxlength) && $input.maxlength} maxlength="{$input.maxlength|intval}"{/if}
																{if isset($input.readonly) && $input.readonly} readonly="readonly"{/if}
															   {if isset($input.disabled) && $input.disabled} disabled="disabled"{/if}
														/>
														{*if isset($input.maxlength) && $input.maxlength}
															<span class="help-block-character" data-id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}">
																<span class="current-character">{$value_text|strlen}</span>/{$input.maxlength|intval}
															</span>
														{/if*}

	                                            {elseif $input.type == 'select'}

							                        <select name="{$input.name|escape:'html':'UTF-8'}"
							                                class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}"
							                                id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}"
	                                                        {if isset($input.multiple) && $input.multiple} multiple="multiple"{/if}
							                        >
	                                                    {if isset($input.options.default)}
									                        <option value="{$input.options.default.value|escape:'html':'UTF-8'}">{$input.options.default.label|escape:'html':'UTF-8'}</option>
	                                                    {/if}
	                                                    {if isset($input.options.query) && is_array($input.options.query) && $input.options.query|count}
	                                                        {foreach $input.options.query AS $option}
	                                                            {if $option == "-"}
											                        <option value="">-</option>
	                                                            {else}
											                        <option value="{$option[$input.options.id]|escape:'html':'UTF-8'}"
	                                                                        {if isset($input.multiple) && $input.multiple}
	                                                                            {if isset($fields_value[$input.name]) && is_array($fields_value[$input.name]) && $fields_value[$input.name]|count}
	                                                                                {foreach $fields_value[$input.name] as $field_value}
	                                                                                    {if $field_value == $option[$input.options.id]}
																	                        selected="selected"
	                                                                                    {/if}
	                                                                                {/foreach}
	                                                                            {/if}
	                                                                        {else}
	                                                                            {if isset($fields_value[$input.name]) && $fields_value[$input.name]|trim == $option[$input.options.id]|trim}
															                        selected="selected"
	                                                                            {/if}
	                                                                        {/if}
											                        >{$option[$input.options.name]|escape:'html':'UTF-8'}</option>

	                                                            {/if}
	                                                        {/foreach}
	                                                    {/if}
							                        </select>

	                                            {elseif $input.type == 'radio'}

	                                                {if isset($input.options.query) && is_array($input.options.query) && $input.options.query|count}
	                                                    {assign var="ik" value="0"}
	                                                    {foreach $input.options.query as $option}
	                                                        {assign var="ik" value=$ik+1}
									                        <div class="radio {if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}">
	                                                            {strip}
											                        <label>
																		<span class="hd_ets_custom_radio">
												                        	<input type="radio"	name="{$input.name|escape:'html':'UTF-8'}" id="{$input.name|escape:'html':'UTF-8'}_{$ik|intval}" value="{$option[$input.options.id]|escape:'html':'UTF-8'}"{if isset($fields_value[$input.name]) && $fields_value[$input.name] == $option[$input.options.id]} checked="checked"{/if}/>
																			<span class="hd_value"></span>
																		</span> {$option[$input.options.name]|escape:'html':'UTF-8'}
											                        </label>
	                                                            {/strip}
									                        </div>
	                                                    {/foreach}
	                                                {/if}

	                                            {elseif $input.type == 'textarea'}

														{if isset($input.maxlength) && $input.maxlength}
															<div class="ets_hd_group_max_textarea">
														{/if}
														<textarea name="{$input.name|escape:'html':'UTF-8'}"
															  id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}"
															  class="{if isset($input.autoload_rte) && $input.autoload_rte}rte autoload_rte{else}textarea-autosize{/if}{if isset($input.class)} {$input.class|escape:'html':'UTF-8'}{/if}"
															  {if isset($input.maxlength) && $input.maxlength} maxlength="{$input.maxlength|intval}"{/if}
														>{if isset($fields_value[$input.name])}{$fields_value[$input.name]|escape:'html':'UTF-8'}{/if}</textarea>
																{if isset($input.maxlength) && $input.maxlength}
															</div>
													{/if}
														{*if isset($input.maxlength) && $input.maxlength}
															<span class="help-block-character" data-id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}">
																<span class="current-character">{$fields_value[$input.name]|strlen}</span>/{$input.maxlength|intval}
															</span>
														{/if*}

	                                            {elseif $input.type == 'checkbox'}

	                                                {if isset($input.options.query) && is_array($input.options.query) && $input.options.query|count}
	                                                    {foreach $input.options.query as $value}
	                                                        {assign var=id_checkbox value=$input.name|cat:'_'|cat:$value.id}
									                        <div class="checkbox">
	                                                            {strip}
											                        <label for="{$id_checkbox|escape:'html':'UTF-8'}">
																		<span class="hd_ets_custom_checkbox">
												                        	<input type="checkbox" name="{$input.name|cat:'['|cat:$value.id|cat:']'}" id="{$id_checkbox|escape:'html':'UTF-8'}" class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}" value="{$value[$input.options.name]|escape:'html':'UTF-8'}"{if isset($fields_value[$input.name]) && is_array($fields_value[$input.name]) && in_array($value[$input.options.name], $fields_value[$input.name])} checked="checked"{/if} />
	                                                                    	<span class="hd_value"></span>
																		</span> {$value[$input.options.name]|escape:'html':'UTF-8'}
											                        </label>
	                                                            {/strip}
									                        </div>
	                                                    {/foreach}
	                                                {/if}

	                                            {elseif $input.type == 'date'}

							                        <div class="row">
														<div class="col-xs-12 col-sm-12 no-padding-frontend type_date">
															<div class="input-group col-lg-12">
																<input
																		id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}"
																		type="text"
																		data-hex="true"
																		{if isset($input.class)} class="{$input.class|escape:'html':'UTF-8'}"
																		{else}class="datepicker"{/if}
																		name="{$input.name|escape:'html':'UTF-8'}"
																		value="{$fields_value[$input.name]|escape:'html':'UTF-8'}"
																		autocomplete="off"
																		{if isset($input.placeholder) && $input.placeholder|trim !== ''} placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if}
																/>
																<span class="input-group-addon">
																	<svg class="fill_gray w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M192 1664h288v-288h-288v288zm352 0h320v-288h-320v288zm-352-352h288v-320h-288v320zm352 0h320v-320h-320v320zm-352-384h288v-288h-288v288zm736 736h320v-288h-320v288zm-384-736h320v-288h-320v288zm768 736h288v-288h-288v288zm-384-352h320v-320h-320v320zm-352-864v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm736 864h288v-320h-288v320zm-384-384h320v-288h-320v288zm384 0h288v-288h-288v288zm32-480v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm384-64v1280q0 52-38 90t-90 38h-1408q-52 0-90-38t-38-90v-1280q0-52 38-90t90-38h128v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h384v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h128q52 0 90 38t38 90z"/></svg>
																</span>
															</div>
														</div>
							                        </div>

	                                            {elseif $input.type == 'datetime'}

							                        <div class="row">
														<div class="col-xs-12 col-sm-12 no-padding-frontend type_datetime">
															<div class="input-group col-lg-12">
																<input
																		id="{if isset($input.id)}{$input.id|escape:'html':'UTF-8'}{else}{$input.name|escape:'html':'UTF-8'}{/if}"
																		type="text"
																		data-hex="true"
																		{if isset($input.class)} class="{$input.class|escape:'html':'UTF-8'}"
																		{else} class="datetimepicker"{/if}
																		autocomplete="off"
																		name="{$input.name|escape:'html':'UTF-8'}"
																		value="{$fields_value[$input.name]|escape:'html':'UTF-8'}"
																		{if isset($input.placeholder) && $input.placeholder|trim !== ''} placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if}
																/>
																<span class="input-group-addon">
																	<svg class="fill_gray w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M192 1664h288v-288h-288v288zm352 0h320v-288h-320v288zm-352-352h288v-320h-288v320zm352 0h320v-320h-320v320zm-352-384h288v-288h-288v288zm736 736h320v-288h-320v288zm-384-736h320v-288h-320v288zm768 736h288v-288h-288v288zm-384-352h320v-320h-320v320zm-352-864v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm736 864h288v-320h-288v320zm-384-384h320v-288h-320v288zm384 0h288v-288h-288v288zm32-480v-288q0-13-9.5-22.5t-22.5-9.5h-64q-13 0-22.5 9.5t-9.5 22.5v288q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5-9.5t9.5-22.5zm384-64v1280q0 52-38 90t-90 38h-1408q-52 0-90-38t-38-90v-1280q0-52 38-90t90-38h128v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h384v-96q0-66 47-113t113-47h64q66 0 113 47t47 113v96h128q52 0 90 38t38 90z"/></svg>
																</span>
															</div>
														</div>
							                        </div>

	                                            {elseif $input.type == 'file'}

														<input id="{$input.name|escape:'html':'UTF-8'}" type="file" name="{$input.name|escape:'html':'UTF-8'}" class="ets_hd_ticket_upload_file">
														{if isset($input.file) && trim($input.file) !== ''}
															<input type="hidden" name="{$input.name|escape:'html':'UTF-8'}_file_dir" value="{$input.file_dir|escape:'html':'UTF-8'}">
															{if !isset($input.required) || !$input.required}
																<input type="hidden" name="{$input.name|escape:'html':'UTF-8'}_deleted" value="0">
															{/if}
															<div class="ets_hd_upload_file">
																<a class="file" href="{$input.file nofilter}">{$input.file_name|escape:'html':'UTF-8'}</a>
																{if !isset($input.required) || !$input.required}
																	<span class="ets_hd_ticket_delete_file" data-ref="{$input.name|escape:'html':'UTF-8'}">
																		<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg>
																	</span>
																{/if}
															</div>
														{/if}
														<p class="help-block">{l s ='Accepted formats: pdf, gif, png, jpg, doc, docx, xls, xlsx, zip. Limit %s' sprintf=[$PS_ATTACHMENT_MAXIMUM_SIZE] mod='ets_helpdesk'}</p>

	                                            {/if}
												{if isset($input.desc) && !empty($input.desc)}
													<p class="help-block">
														{if is_array($input.desc)}
															{foreach $input.desc as $p}
																{if is_array($p)}
																	<span id="{$p.id|intval}">{$p.text nofilter}</span><br />
																{else}
																	{$p nofilter}<br />
																{/if}
															{/foreach}
														{else}
															{$input.desc|nl2br nofilter}
														{/if}
													</p>
												{/if}
												</div>
					                        </div>
				                        </div>
	                                {/if}
                                {/foreach}
                            {/if}
			                {if isset($reCAPTCHA) && $reCAPTCHA > 0 && isset($configs) && isset($configs.ETS_HD_ALLOW_CAPTCHA) && $configs.ETS_HD_ALLOW_CAPTCHA > 0 && !$configs.ETS_HD_CUSTOMER_NO_CAPTCHA}
				                <div class="form-group">
					                <label class="control-label col-lg-3"></label>
					                <div class="col-lg-9">
						                <div class="ets-hd-g-recaptcha">
                                            {if $configs.ETS_HD_CAPTCHA_TYPE|trim != 'recaptcha_v2'}
								                <input id="g-recaptcha-response" class="g-recaptcha-response" name="g-recaptcha-response" type="hidden">
                                            {else}
								                <div class="g-recaptcha" data-callback="ets_hd_g_recaptcha"></div>
								                <p class="desc_error" style="display: none;">{l s='Captcha is required' mod='ets_helpdesk'}</p>
                                            {/if}
						                </div>
					                </div>
				                </div>
			                {/if}
		                </div>
					{/if}
                {/foreach}
                {if isset($form.submit) || isset($form.buttons)}
					<div class="panel-footer">
                        {if isset($form.submit)}
							<button type="submit" value="1" id="{if isset($table)}{$table|escape:'html':'UTF-8'}{/if}form_submit_btn" name="{$form.submit.name|escape:'html':'UTF-8'}" class="btn btn btn-primary pull-right">
								{if $form.submit.icon}
									{if isset($form.submit.icon)}
										<i class="{$form.submit.icon|escape:'html':'UTF-8'}"></i>
									{/if}
								{/if}
								{if isset($configs.ETS_HD_BUTTON_SUBMIT_LABEL) && $configs.ETS_HD_BUTTON_SUBMIT_LABEL}{$configs.ETS_HD_BUTTON_SUBMIT_LABEL|escape:'html':'UTF-8'}{else}{$form.submit.title|escape:'html':'UTF-8'}{/if}
							</button>
                        {/if}
                        {if isset($form.buttons) && is_array($form.buttons) && $form.buttons|count > 0}
	                        {foreach from=$form.buttons key='id' item='button'}
	                            {if isset($button.href)}
                                    <a{if isset($button.class)} class="btn {if $button.icon} {if $button.icon != 'svg_back'} btn-primary {/if}{/if}{$button.class|escape:'html':'UTF-8'}"{/if} href="{$button.href nofilter}">
										{if $button.icon}
											{if $button.icon == 'svg_back'}
												<i class="ets_svg_fill_white">
													<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 800v192q0 14-9 23t-23 9h-1248v224q0 21-19 29t-35-5l-384-350q-10-10-10-23 0-14 10-24l384-354q16-14 35-6 19 9 19 29v224h1248q14 0 23 9t9 23z"/></svg>
												</i>
											{else}
												<i class="sa {$button.icon|escape:'html':'UTF-8'}"></i>
											{/if}
										{/if}
										{$button.title|escape:'html':'UTF-8'}</a>
	                            {else}
		                            <button type="button" value="1" id="{if isset($table)}{$table|escape:'html':'UTF-8'}{/if}form_button_btn" name="{$button.name|escape:'html':'UTF-8'}" name="{$id|escape:'html':'UTF-8'}" class="btn btn-primary pull-right">
										{if $button.icon}
											{if $button.icon == 'process-icon-save'}
												<i class="ets {$button.icon|escape:'html':'UTF-8'}">
													<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M512 1536h768v-384h-768v384zm896 0h128v-896q0-14-10-38.5t-20-34.5l-281-281q-10-10-34-20t-39-10v416q0 40-28 68t-68 28h-576q-40 0-68-28t-28-68v-416h-128v1280h128v-416q0-40 28-68t68-28h832q40 0 68 28t28 68v416zm-384-928v-320q0-13-9.5-22.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 22.5v320q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5-9.5t9.5-22.5zm640 32v928q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1344q0-40 28-68t68-28h928q40 0 88 20t76 48l280 280q28 28 48 76t20 88z"/></svg>
												</i>
											{else}
												<i class="ets {$button.icon|escape:'html':'UTF-8'}"></i>
											{/if}
										{/if}{$button.title|escape:'html':'UTF-8'}
									</button>
	                            {/if}
	                        {/foreach}
                        {/if}
					</div>
                {/if}
			{/if}
		</div>
	</form>
{/if}