/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2022 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

var ets_hd_allow_ext_image_files = ets_hd_allow_ext_image_files || ['jpg', 'png', 'jpeg', 'gif'];

var ets_hd_front_fn = {
    readURL: function (input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#ets_hd_avatar_thumbnail > img')
                    .attr({'src': e.target.result, 'title': input.files[0].name})
                    .css('max-width', '110px')
                    .addClass('image-loading')
                ;
            };
            reader.readAsDataURL(input.files[0]); // convert to base64 string
        }
    },
    copyToClipboard: function (el) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val(el.text()).select();
        document.execCommand("copy");
        $temp.remove();
        el.parent().addClass('copied');
        //showSuccessMessage(ets_hd_copied_translate);
        setTimeout(function () {
            el.removeClass('copy');
            el.parent().removeClass('copied');
        }, 1500);
    },
    isSafari: function () {
        var e = navigator, c = e.userAgent, g = e.vendor;
        return (!(/(Chrome|CriOS)\s*\/\s*(\d[\d\.]*)/i).test(c) && ((/Apple/i).test(g) || !g) && (/Safari\s*\/\s*(\d[\d\.]*)/i).test(c));
    },
    init: function () {
        if ($('body[id=identity]').length > 0 && $('#customer-form input[name=birthday], #identity input[name=confirmation]').length > 0 && $('.ets_hd_upload_avatar').length > 0) {
            var form_field = $('.ets_hd_upload_avatar .form-group').clone(true);
            $('#customer-form input[name=birthday], #identity input[name=confirmation]').parents('.form-group').after(form_field);
            $('.ets_hd_upload_avatar').remove();
        }
    }
};
$(document).ready(function () {

    ets_hd_front_fn.init();

    // Contact support team:
    var contact_order = $('.ets_hd_contact_order_ref');
    if (contact_order.length > 0 && $('#order-infos').length > 0) {
        $('#order-infos .box:first .row:first div:first strong').append(contact_order.find('a.btn').clone());
    }
    var contact_support_team = $('#history').length > 0;
    if (contact_support_team) {
        $(document).ajaxComplete(function (event, xhr, settings) {
            if (xhr.readyState === 4 && ETS_HD_PROCESS_LINK) {
                let matches = settings.url.match(/(?:\&|\?)controller\s*=\s*order-detail(?:.*?)\&id_order\s*=\s*(\d+)\&?/);
                if (matches !== null && typeof matches[1] !== "undefined") {
                    contact_support_team = false;
                    $.ajax({
                        type: 'GET',
                        url: ETS_HD_PROCESS_LINK,
                        data: {
                            ajax: 1,
                            action: 'buttonContact',
                            id_order: matches[1],
                        },
                        dataType: 'json',
                        success: function (json) {
                            if (json) {
                                var contact_support_team_wrap = $('#block-order-detail .box-small .dark');
                                if (json.contact && $('#block-order-detail .ets_hd_contact_order_ref').length <= 0 && contact_support_team_wrap.length > 0) {
                                    contact_support_team_wrap.append(json.contact);
                                    $('#block-order-detail .ets_hd_contact_order_ref').show();
                                }
                            }
                        }
                    });
                }
            }
        });
    }
    // End contact support team:

    $(document).on('click', '.ets_hd_cancel, span.ets_hd_close_form', function (e) {
        e.preventDefault();
        $('.ets_hd_overload.active').removeClass('active');
    });

    $(document).on('click', '.ets_hd_profile_image #ets_hd_avatar-selectbutton', function () {
        $('#customer-form .ets_hd_profile_image input[name=ets_hd_avatar], #identity .ets_hd_profile_image input[name=ets_hd_avatar]').trigger('click');
    });

    $(document).on('change', '#customer-form .ets_hd_profile_image input[name=ets_hd_avatar], #identity .ets_hd_profile_image input[name=ets_hd_avatar]', function () {
        var _thumb = $('#ets_hd_avatar_thumbnail'),
            form = _thumb.parents('form'),
            image = _thumb.find('img'),
            profile_image = $('.ets_hd_profile_image'),
            wrap_error_html = '<div class="bootstrap"><div class="ets_hd_upload_error alert alert-danger"></div></div>',
            wrap_input = profile_image.find('.input-group.js-parent-focus')
        ;
        if (this.files[0]) {
            form.removeClass('ets_hd_alert');
            wrap_input.removeClass('ets_hd_alert');
            profile_image.find('.ets_hd_upload_error').remove();
            if (this.files[0].size > parseInt(ets_hd_post_max_size)) {
                wrap_input.addClass('ets_hd_alert');
                form.addClass('ets_hd_alert');
                if (profile_image.find('.ets_hd_upload_error').length <= 0) {
                    profile_image.append(wrap_error_html);
                }
                profile_image.find('.ets_hd_upload_error').html(ets_hd_max_file_size_msg);
            } else {
                var extension = this.files[0].name.toLowerCase().substr((this.files[0].name.lastIndexOf('.') + 1));
                if (ets_hd_allow_ext_image_files.indexOf(extension) < 0) {
                    wrap_input.addClass('ets_hd_alert');
                    form.addClass('ets_hd_alert');
                    if (profile_image.find('.ets_hd_upload_error').length <= 0) {
                        profile_image.append(wrap_error_html);
                    }
                    profile_image.find('.ets_hd_upload_error').html(ets_hd_allow_ext_file_msg);
                }
            }
        }
        if (!wrap_input.hasClass('ets_hd_alert') && !_thumb.hasClass('loading') && $(this).val()) {
            _thumb.addClass('loading');
            $('#avatar-name').val(this.files[0].name);
            if (_thumb.find('img').length <= 0) {
                _thumb.append('<img/><span class="ets_hd_delete_avatar" title="' + _thumb.data('btn-delete-title') + '"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span>');
            }
            ets_hd_front_fn.readURL(this);
            var formData = new FormData(form[0]);
            if (form.find('input[type="file"]').length > 0 && ets_hd_front_fn.isSafari()) {
                form.find('input[type="file"]').each(function () {
                    if (document.getElementById($(this).attr('id')).files.length === 0) {
                        formData.delete($(this).attr('id'));
                    }
                });
            }

            formData.append('ajax', 1);
            formData.append('action', 'uploadProfileImage');

            $.ajax({
                url: _thumb.data('upload-url'),
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function (json) {
                    _thumb.removeClass('loading');
                    if (json) {
                        image.removeClass('image-loading');
                        if (json.errors) {
                            if (profile_image.find('.ets_hd_upload_error').length <= 0) {
                                profile_image.append(wrap_error_html);
                            }
                            profile_image.find('.ets_hd_upload_error').html(json.errors);
                            image.hide();
                        } else {
                            var profile_image = $('.ets_hd_profile_image .bootstrap');
                            if (json.msg)
                                $.growl.notice({title: "", message: json.msg});
                            if (profile_image.length > 0) {
                                profile_image.hide();
                                image.show();
                            }
                        }
                    }
                },
                error: function () {
                    _thumb.removeClass('loading');
                }
            });
        }
    });

    $(document).on('click', '.ets_hd_delete_avatar', function () {
        var btn = $(this), _thumb = $('#ets_hd_avatar_thumbnail');
        if (!btn.hasClass('active') && _thumb.data('upload-url') !== '') {
            btn.addClass('active');
            $.ajax({
                url: _thumb.data('upload-url'),
                type: 'POST',
                data: 'ajax=1&action=deleteProfileImage',
                dataType: 'json',
                success: function (json) {
                    btn.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            var wrap_error = $('.ets_hd_profile_image .ets_hd_alert');
                            if (!wrap_error.length > 0) {
                                $('.ets_hd_profile_image').append('<div class="bootstrap"><div class="ets_hd_alert alert alert-danger"></div></div>');
                            }
                            wrap_error.html(json.errors);
                        } else {
                            if (json.msg)
                                $.growl.notice({title: "", message: json.msg});
                            _thumb.html('');
                        }
                    }
                },
                error: function () {
                    btn.removeClass('active');
                }
            });
        }
    });
});