/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2022 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */
var ETS_HD_PROCESS_LINK = ETS_HD_PROCESS_LINK || '';
var ets_hd_fn = {
    init: function () {
        ets_hd_fn.searchProduct();
        ets_hd_fn.searchCustomer();
        ets_hd_fn.searchCustomer($('input[name=search_customer_id]'), true);
    },
    closeSearch: function (dom, destroy) {
        if (dom.length > 0) {
            var _destroy = destroy || false;
            if (dom.length > 0)
                dom.val('');
            if (_destroy)
                dom.unautocomplete();
        }

        return this;
    },
    searchProduct: function (input_search) {
        if ($.fn.autocomplete) {
            var dom = input_search || $('input[name=search_product]');
            if (dom.length > 0 && ETS_HD_PROCESS_LINK !== '') {
                dom.autocomplete(ETS_HD_PROCESS_LINK + (ETS_HD_PROCESS_LINK.indexOf('?') !== -1 ? '&' : '?') + 'ajax=1&action=searchProduct&time=' + new Date().getTime(), {
                    resultsClass: "ets_hd_product_results",
                    appendTo: '.ets_hd_product_search',
                    delay: 100,
                    minChars: 1,
                    autoFill: true,
                    max: 20,
                    matchContains: true,
                    mustMatch: true,
                    scroll: false,
                    cacheLength: 0,
                    multipleSeparator: '||',
                    formatItem: function (item) {
                        return '<span data-id="' + item[0] + '"><img src="' + item[3] + '" title="' + item[1] + (item[2] ? ' (' + item[2] + ')' : '') + '" width="64"/>' + item[1] + (item[2] ? ' (' + item[2] + ')' : '') + '</span>';
                    }
                }).result(function (event, item) {
                    if (item == null)
                        return false;

                    $('input[name=id_product]').val(item[0]);
                    $('.ets_hd_product_search')
                        .addClass('active')
                        .html('<div class="ets_hd_product_item" data-id="' + item[0] + '"><img src="' + item[3] + '" title="' + item[1] + (item[2] ? ' (' + item[2] + ')':'')+'" width="64"/>' + item[1] +(item[2] ? ' (' + item[2] + ')':'') +'<span class="remove_ctm lh_16"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span></div>');

                    ets_hd_fn.closeSearch(dom);
                });
            }
        }

        return false;
    },
    removeIds: function (parent, element) {
        var ax = -1;
        if ((ax = parent.indexOf(element)) !== -1)
            parent.splice(ax, 1);
        return parent;
    },
    searchCustomer: function (input_search, single) {
        if ($.fn.autocomplete) {
            var dom = input_search || $('input[name=search_customer]'),
                singleCustomer = single || false,
                form = dom.parents('form'),
                customerIds = $('#id_customer')
            ;
            if (dom.length > 0 && form.length > 0 && ETS_HD_PROCESS_LINK !== '') {
                dom.autocomplete(ETS_HD_PROCESS_LINK + (ETS_HD_PROCESS_LINK.indexOf('?') !== -1 ? '&' : '?') + 'ajax=1&action=searchCustomer&time=' + new Date().getTime(), {
                    resultsClass: "ets_hd_customer_results",
                    appendTo: '.ets_hd_customer_search',
                    delay: 100,
                    minChars: 1,
                    autoFill: true,
                    max: 20,
                    matchContains: true,
                    mustMatch: true,
                    scroll: false,
                    cacheLength: 0,
                    multipleSeparator: '||',
                    extraParams: {
                        excludeIds: customerIds.val(),
                    },
                    formatItem: function (item) {
                        return '<span data-id="' + item[0] + '">' + item[0] + '-' + item[1] + ' ' + item[2] + ' (' + item[3] + ') </span>';
                    }
                }).result(function (event, item) {
                    if (item == null)
                        return false;

                    if (!singleCustomer) {
                        var customerItem = $('.ets_hd_customer_staff_item_tmp');
                        customerItem
                            .before(customerItem.html()
                                .replace('@ETS_HD_CUSTOMER_ID@', item[0])
                                .replace('@ETS_HD_CUSTOMER_NAME@', item[1] + ' ' + item[2])
                                .replace('@ETS_HD_CUSTOMER_EMAIL@', item[3])
                            );
                        if (customerIds.val() === '') {
                            customerIds.val(item[0]);
                        } else {
                            var customers = customerIds.val().split(',');
                            if (customers.indexOf(item[0]) === -1) {
                                customers.push(item[0]);
                            }
                            customerIds.val(customers.join(','));
                        }
                        ets_hd_fn.closeSearch(dom, true);
                        ets_hd_fn.searchCustomer(dom);
                    } else {
                        customerIds.val(item[0]);
                        $('.ets_hd_customer_search')
                            .addClass('active')
                            .html('<div class="ets_hd_customer_item" data-id="' + item[0] + '">' + item[0] + '-' + item[1] + ' ' + item[2] + ' (' + item[3] + ') <span class="remove_ctm lh_16"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span></div>')
                        ;
                        ets_hd_fn.closeSearch(dom);
                    }
                });
            }
        }

        return false;
    },
}