/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2022 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */
var ETS_HD_LINE_CHART;
var _drawChart = {
    addChart: function (cavans, json) {
        return new Chart(cavans, {
            type: 'line',
            data: {
                datasets: json.datasets,
                labels: json.labels,
            },
            spanGaps: true,
            options: {
                responsive: true,
                title: {
                    text: json.title,
                    position: 'top',
                },
                scales: {
                    xAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: json.labelX
                        },
                    }],
                    yAxes: [{
                        ticks: {
                            min: 0,
                            stepSize: 1
                        },
                        scaleLabel: {
                            display: true,
                            labelString: json.labelY
                        },
                    }]
                },
                legend: {
                    fullWidth: true,
                    position: 'bottom',
                },
                layout: {
                    padding: {
                        left: 20,
                        top: 20,
                        bottom: 20
                    }
                },
                tooltips: {
                    mode: 'point',
                    intersect: true,
                }
            }
        });
    },
    updateChart: function (json) {
        ETS_HD_LINE_CHART.data.labels = json.dataAxesX || [];
        ETS_HD_LINE_CHART.data.datasets = json.datasets || [];
        ETS_HD_LINE_CHART.options.title.text = json.title || [];
        ETS_HD_LINE_CHART.options.scales.xAxes = [{
            scaleLabel: {
                display: true,
                labelString: json.axesX || [],
            },
        }];
        ETS_HD_LINE_CHART.options.scales.yAxes = [{
            ticks: {
                min: 0,
                stepSize: 1
            },
            scaleLabel: {
                display: true,
                labelString: json.axesY || [],
                type: 'int',
            },
        }];
        ETS_HD_LINE_CHART.update();
    },
    refresh: function (btn) {
        if ($('#ets_hd_line_charts').length > 0 && !btn.hasClass('loading') > 0 && ETS_HD_CURRENT_INDEX) {
            var selectType = btn.data('id');
            if (selectType !== 'time_range' || btn.find('input[name=to]').val() && btn.find('input[name=from]').val()) {
                btn.addClass('xml-http-request');
                $.ajax({
                    url: ETS_HD_CURRENT_INDEX,
                    type: 'POST',
                    dataType: 'json',
                    data: 'ajax=1&action=updateStats&filter_type=' + selectType + (selectType !== 'time_range' ? '' : '&from=' + btn.find('input[name=from]').val() + '&to=' + btn.find('input[name=to]').val()),
                    success: function (json) {
                        btn.removeClass('xml-http-request');
                        if (json) {
                            if (json.errors) {
                                showErrorMessage(json.errors);
                            } else {
                                if (json.tickets_number) {
                                    $('.ets_hd_ticket_number_stats').html(json.tickets_number);
                                }
                                if (json.line_charts) {
                                    _drawChart.updateChart(json.line_charts);
                                }
                                if (json.top_modules) {
                                    $('.ets_hd_top_support_stats').html(json.top_modules);
                                }
                                if (json.top_staffs) {
                                    $('.ets_hd_top_staff_stats').html(json.top_staffs);
                                }
                            }
                        }
                    },
                    error: function () {
                        btn.removeClass('xml-http-request');
                    }
                });
            }
        }
    },
};
var _dashHDFn = {
    filters: function (option) {
        var ele = option || $('.ets_hd_filter_li:first');
        $('.ets_hd_filter_li').removeClass('active');
        ele.addClass('active');
        _drawChart.refresh(ele);
    }
}
$(document).ready(function () {
    var datepicker = $('.datepicker');
    if (datepicker.length > 0) {
        datepicker.datepicker({
            prevText: '',
            nextText: '',
            dateFormat: 'yy-mm-dd',
            timeFormat: 'hh:mm:ss',
        });
    }
    var line_charts = $('#ets_hd_line_charts');
    if (line_charts.length > 0 && ETS_HD_LC_DATASET) {
        ETS_HD_LINE_CHART = _drawChart.addChart(line_charts, {
            title: ETS_HD_LC_TITLE,
            labels: ETS_HD_LC_DATA_AXESX,
            datasets: ETS_HD_LC_DATASET,
            labelX: ETS_HD_LC_AXESX,
            labelY: ETS_HD_LC_AXESY,
        });
    }
    $(document).on('click', 'li.ets_hd_filter_li:not([data-id=time_range])', function () {
        $('.ets_hd_filter_li #from').val('');
        $('.ets_hd_filter_li #to').val('');
        _dashHDFn.filters($(this));
    });
    $(document).on('change input', 'li.ets_hd_filter_li[data-id=time_range] .datepicker', function () {
        var parentLi = $('li.ets_hd_filter_li[data-id=time_range]');
        _dashHDFn.filters(parentLi);
    });
});