<?php
/**
 * 2007-2022 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2022 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once dirname(__FILE__) . '/AdminEtsHDFormController.php';

class AdminEtsHDCronjobController extends AdminEtsHDFormController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->show_form_cancel_button = false;
        $this->list_no_link = true;
        $this->toolbar_btn = array();
        $this->show_toolbar = false;
        $this->list_simple_header = false;

        parent::__construct();
    }

    public function init()
    {
        parent::init();

        $this->fields_options = array(
            'title' => $this->l('Cronjob'),
            'fields' => HDDefines::getInstance()->getConfigsCronjob(),
        );
    }

    public function initContent()
    {
        parent::initContent();
    }

    public function ajaxProcessClearLog()
    {
        if (Configuration::getGlobalValue('ETS_HD_SAVE_CRONJOB_LOG')) {
            Configuration::updateGlobalValue('ETS_HD_CRONJOB_LOG', '', true);
        }
        die(json_encode(array(
            'msg' => $this->l('Clear successfully'),
        )));
    }

    public function ajaxProcessRunCronjob()
    {
        HDPostProcess::getInstance($this->module, $this->context, $this->ajax)
            ->allowAccess(true)
            ->runCronjob();
    }

    public function renderOptions($ret = false)
    {
        /*
        $this->tpl_option_vars['sub_tabs'] = array(
            'config' => $this->l('Configuration'),
            'log' => $this->l('Cronjob log'),
        );*/
        $current_tab = Tools::getValue('current_tab');
        if (trim($current_tab) == '' ||
            !Validate::isCleanHtml($current_tab)
        ) {
            $current_tab = 'config';
        }
        $this->tpl_option_vars['current_tab'] = $current_tab;
        $this->tpl_option_vars['base_link'] = $this->context->link->getAdminLink('AdminEtsHDCronjob');
        $this->tpl_option_vars['base_dir'] = _PS_MODULE_DIR_ . 'ets_helpdesk/cronjob.php';
        $this->tpl_option_vars['php_path'] = (defined('PHP_BINDIR') && PHP_BINDIR && is_string(PHP_BINDIR) ? PHP_BINDIR.'/' : '').'php ';
        if($cronjob_time = Configuration::getGlobalValue('ETS_HD_CRONJOB_TIME'))
        {
            $cronjob_last =$this->module->displayTimeByDate($cronjob_time);
            $this->tpl_option_vars['cronjob_last']   = $cronjob_last;
        }
        return parent::renderOptions($ret);
    }

    public function setHelperDisplay(Helper $helper)
    {
        $this->toolbar_btn = array();
        $this->bulk_actions = array();

        parent::setHelperDisplay($helper);
    }

}