<?php
/**
 * 2007-2022 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2022 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class AdminEtsHDBaseController extends ModuleAdminController
{
    public $breadcrumb = array();

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJS(array(
            $this->module->getPathUri() . 'views/js/helpdesk.admin.js',
            $this->module->getPathUri() . 'views/js/helpdesk.function.js',
        ));
        $this->addCSS($this->module->getPathUri() . 'views/css/helpdesk.admin.css');
    }

    public function initContent()
    {
        $this->initMenus();

        parent::initContent();
        if($this->context->cookie->_success)
        {
            $this->content .= $this->module->displayConfirmation($this->context->cookie->_success);
            $this->context->cookie->_success ='';
            $this->context->cookie->write();
        }
        if($this->context->cookie->_error_message)
        {
            $this->content .= $this->module->displayError($this->context->cookie->_error_message);
            $this->context->cookie->_error_message ='';
            $this->context->cookie->write();
        }
    }

    public function initMenus($ret = false)
    {
        if (($quickTabs = HDDefines::getInstance()->getQuickTabs())
            && is_array($quickTabs)
            && count($quickTabs) > 0
        ) {
            foreach ($quickTabs as &$tab) {
                $tab['link'] = $this->context->link->getAdminLink(Ets_helpdesk::_ADMIN_TAB_PREFIX_ . $tab['class']);
            }
        }
        $this->context->smarty->assign(array(
            'menus' => $quickTabs,
            'current' => $this->controller_name,
            'ADMIN_TAB_PREFIX' => Ets_helpdesk::_ADMIN_TAB_PREFIX_,
            'content' => $this->content,
            '_img_path'=> $this->module->getPathUri().'views/img/',
            'breadcrumbs' => $this->breadcrumb,
        ));
        $menu = $this->displayHook('bo-menu.tpl');
        if ($ret) {
            return $menu;
        }
        $this->content .= $menu;
    }

    public function isGranted()
    {
        return (
            !isset($this->context->employee->id) ||
            $this->context->employee->id <= 0 ||
            (int)$this->context->employee->id_profile != _PS_ADMIN_PROFILE_ && ( !HDStaff::isGranted(0, $this->context->employee->id)) // trim($this->controller_name) !== 'AdminEtsHDTickets' ||
        ) ? 0 : 1;
    }

    public function viewAccess($disable = false)
    {
        return parent::viewAccess($disable) && $this->isGranted();
    }

    public function displayHook($template)
    {
        return $this->module->display($this->module->getLocalPath() . $this->module->name . '.php', $template);
    }

    public function ajaxJson($data)
    {
        die(json_encode($data));
    }
}