<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDValidate extends Validate
{
    /**
     * @param $mails string
     */
    public static function isListEmail($mails)
    {
        if (!is_array($mails) && trim($mails) !== '') {
            $mails = explode(',', $mails);
        }
        if (!is_array($mails) || count($mails) < 0) {
            return false;
        }
        foreach ($mails as $mail) {
            if (trim($mail) !== '' && !Validate::isEmail(trim($mail))) {
                return false;
            }
        }

        return true;
    }
    public static function isUnsignedFloat($value)
    {
        if(!Validate::isUnsignedFloat($value))
            return false;
        else
            return $value ? true: false;
    }
    public static function validateArray($array,$validate='isCleanHtml')
    {
        if(!is_array($array))
        {
            if(method_exists('Validate',$validate))
            {
                return Validate::$validate($array);
            }
            return true;
        }
        if(method_exists('Validate',$validate))
        {
            if($array && is_array($array))
            {
                $ok= true;
                foreach($array as $val)
                {
                    if(!is_array($val))
                    {
                        if($val && !Validate::$validate($val))
                        {
                            $ok= false;
                            break;
                        }
                    }
                    else
                        $ok = self::validateArray($val,$validate);
                }
                return $ok;
            }
        }
        return true;
    }
}