<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

if (!defined('_PS_VERSION_'))
    exit;


class HDTranslate
{
    public function l($string, $source = null)
    {
        return Translate::getModuleTranslation('ets_helpdesk', $string, $source ?: pathinfo(__FILE__, PATHINFO_FILENAME));
    }
    
    public static function trans($originalString, $lang, $source = null)
    {
        static $module_name = 'ets_helpdesk';

        if (is_array($lang)) {
            $iso_code = $lang['iso_code'];
        } elseif (is_object($lang)) {
            $iso_code = $lang->iso_code;
        } else {
            $language = new Language($lang);
            $iso_code = $language->iso_code;
        }

        $translationFile = rtrim(_PS_MODULE_DIR_, '/') . '/' . $module_name . '/translations/' . $iso_code . '.' . 'php';

        if (!@file_exists($translationFile)) {
            return $originalString;
        }

        $contentFile = Tools::file_get_contents($translationFile);
        $string = preg_replace("/\\\*'/", "\'", $originalString);
        $key = md5($string);
        $keyFile =Tools::strtolower('<{' . $module_name . '}prestashop>' . ($source ?: $module_name)) . '_' . $key;

        preg_match('/(\$_MODULE\[\'' . preg_quote($keyFile) . '\'\]\s*=\s*\')(.*)(\';)/', $contentFile, $matches);
        if ($matches && isset($matches[2])) {
            return Tools::stripslashes($matches[2]);
        }
        return $originalString;
    }
}