<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDTicketMessage extends ObjectModel
{
    public $id_ets_hd_ticket;
    public $message;
    public $attachment;
    public $id_customer;
    public $id_employee;
    public $is_staff;
    public $mark_as_replied;
    public $response_time;
    public $date_add;
    public $date_upd;
    public $attachment_file_mail;

    public static $definition = array(
        'table' => 'ets_hd_ticket_message',
        'primary' => 'id_ets_hd_ticket_message',
        'fields' => array(
            'id_ets_hd_ticket' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'message' => array('type' => self::TYPE_HTML, 'validate' => 'isCleanHtml'),
            'attachment' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'id_customer' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_employee' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'is_staff' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'mark_as_replied' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'response_time' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        )
    );

    public static function getInstanceById($id)
    {
        if (!$id ||
            !Validate::isUnsignedInt($id)
        ) {
            return false;
        }
        return new self($id);
    }

    public static function getMessagesByTicket($id_ets_hd_ticket)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return false;
        }
        $dq = new DbQuery();
        $dq
            ->select('*')
            ->from('ets_hd_ticket_message')
            ->where('id_ets_hd_ticket=' . (int)$id_ets_hd_ticket);

        return Db::getInstance()->executeS($dq);
    }

    public static function deleteMessageByTicket($id_ets_hd_ticket)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return false;
        }

        return Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . 'ets_hd_ticket_message` WHERE id_ets_hd_ticket=' . (int)$id_ets_hd_ticket);
    }

    public static function getMessages($id = 0, $id_ets_hd_ticket = 0, $nb = 0, $p = 0, $n = 0, $order_by = null, $context = null, $first = false,$where='')
    {
        if ($id_ets_hd_ticket > 0 && !Validate::isUnsignedInt($id_ets_hd_ticket)) {
            return false;
        }
        if ($context == null) {
            $context = Context::getContext();
        }
        $dq = new DbQuery();
        $dq
            ->from('ets_hd_ticket_message', 'a')
            ->leftJoin('customer', 'c', 'c.id_customer = a.id_customer')
            ->leftJoin('employee', 'e', 'e.id_employee = a.id_employee');
        if ($id_ets_hd_ticket > 0) {
            $dq
                ->leftJoin('ets_hd_ticket', 't', 't.id_ets_hd_ticket = a.id_ets_hd_ticket')
                ->where('a.id_ets_hd_ticket = ' . (int)$id_ets_hd_ticket);
        }
        if ($nb > 0) {
            $dq
                ->select('COUNT(id_ets_hd_ticket_message)');
            return Db::getInstance()->getValue($dq);
        }
        $dq
            ->select('a.*
                , IF(a.id_customer > 0, CONCAT(c.firstname, " ", c.lastname), CONCAT(e.firstname, " ", e.lastname)) as `username`
                , IF(a.id_customer > 0, ec.avatar, es.avatar) as `avatar`
                , MD5(CONCAT(IFNULL(a.id_employee, 0), IFNULL(a.id_customer, 0), IFNULL(a.is_staff, 0))) as `unique`
                , es.signature
            ')
            ->leftJoin('ets_hd_customer', 'ec', 'ec.id_customer = a.id_customer')
            ->leftJoin('ets_hd_staff', 'es', 'es.id_employee = a.id_employee');
        if (isset($context->employee->id) && $context->employee->id > 0) {
            $dq
                ->select('IF(a.id_employee > 0 AND a.id_employee = ' . (int)$context->employee->id . ', 1, 0) as `yourself`');
        } elseif (isset($context->customer->id) && $context->customer->id > 0) {
            $dq
                ->select('IF(a.id_customer > 0 AND a.id_customer = ' . (int)$context->customer->id . ', 1, 0) as `yourself`');
        }
        if ($id > 0) {
            $dq
                ->where('a.id_ets_hd_ticket_message=' . (int)$id);
            return Db::getInstance()->getRow($dq);
        }
        if ($p <= 0 || !Validate::isUnsignedInt($p))
            $p = 1;
        if ($n <= 0 || !Validate::isUnsignedInt($n))
            $n = 20;
        if (null === $order_by || !Validate::isCleanHtml($order_by) || !($order_by_items = explode('.', $order_by)) || count($order_by_items) < 1) {
            $order_by = 'a.date_add ASC';
        } else {
            if (!isset($order_by_items[1]) || trim($order_by_items[1]) == '' || !Validate::isSortDirection(Tools::strtoupper(trim($order_by_items[1])))) {
                $order_by_items[1] = 'ASC';
            } else
                $order_by_items[1] = Tools::strtoupper(trim($order_by_items[1]));
            if (!isset($order_by_items[0]) || trim($order_by_items[0]) == '') {
                $order_by_items[0] = 'a.date_add';
            } else
                $order_by_items[0] = 'a.' . trim($order_by_items[0]);
            $order_by = implode(' ', $order_by_items);
        }
        $dq
            ->groupBy('a.id_ets_hd_ticket_message, `avatar`, es.signature')
            ->orderBy($order_by);
        if (!$first)
            $dq->limit($n, $n * ($p - 1));
        if($where)
            $dq->where($where);
        return $first ? Db::getInstance()->getRow($dq) : Db::getInstance()->executeS($dq);
    }

    public static function getLastMessageByTicket($id_ets_hd_ticket)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return false;
        }
        $id = (int)Db::getInstance()->getValue('SELECT MAX(id_ets_hd_ticket_message) FROM `' . _DB_PREFIX_ . 'ets_hd_ticket_message` WHERE id_ets_hd_ticket=' . (int)$id_ets_hd_ticket);
        if ($id > 0) {
            return new HDTicketMessage($id);
        }
        return false;
    }

    public static function makeTicketOfStaff($id_ets_hd_ticket)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return 0;
        }
        $dq = new DbQuery();
        $dq
            ->from('ets_hd_ticket_message', 'tm')
            ->where('tm.id_ets_hd_ticket = ' . (int)$id_ets_hd_ticket)
            ->groupBy('st.id_ets_hd_staff');

        $dq1 = clone $dq;
        $dq1
            ->select('
                st.id_ets_hd_staff
                , COUNT(tm.id_ets_hd_ticket_message) `nb`
                , MAX(tm.id_ets_hd_ticket_message) `max_id`
            ')
            ->orderBy('`nb` DESC, `max_id` DESC')
            ->limit(1);
        $dq2 = clone $dq1;
        $dq1
            ->leftJoin('ets_hd_staff', 'st', 'st.id_employee = tm.id_employee')
            ->where('st.id_employee > 0  AND st.active > 0');
        $dq2
            ->leftJoin('ets_hd_staff', 'st', 'st.id_customer = tm.id_customer')
            ->where('st.id_customer > 0 AND tm.is_staff > 0 AND st.active > 0');

        $res = Db::getInstance()->getRow('(' . $dq1->build() . ') UNION (' . $dq2->build() . ') ORDER BY `nb` DESC, `max_id` DESC');
        if (!$res) {
            $dq3 = clone $dq;
            $dq3
                ->select('st.id_ets_hd_staff, tm.id_ets_hd_ticket_message')
                ->leftJoin('ets_hd_staff', 'st', 'st.id_ets_hd_staff = tm.mark_as_replied')
                ->where('tm.mark_as_replied > 0 AND st.active > 0')
                ->orderBy('MAX(tm.date_upd) DESC')
            ;
            $res = Db::getInstance()->getRow($dq3);
        }
        if ($res) {
            return HDDepartment::saveData((int)$id_ets_hd_ticket, (int)$res['id_ets_hd_staff'], 1);
        }
        return false;
    }
}