<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDTicket extends ObjectModel
{
    public $id_customer;
    public $id_employee;
    public $id_guest;
    public $customer_name;
    public $customer_email;
    public $id_product;
    public $status;
    public $priority;
    public $replied;
    public $staff_replied;
    public $read;
    public $staff_read;
    public $rating;
    public $order_ref;
    public $date_add;
    public $date_upd;

    public static $definition = array(
        'table' => 'ets_hd_ticket',
        'primary' => 'id_ets_hd_ticket',
        'fields' => array(
            'id_customer' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_employee' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_guest' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'customer_name' => array('type' => self::TYPE_STRING, 'validate' => 'isCatalogName', 'size' => 255),
            'customer_email' => array('type' => self::TYPE_STRING, 'validate' => 'isEmail', 'size' => 255),
            'id_product' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'order_ref' => array('type' => self::TYPE_STRING, 'validate' => 'isReference'),
            'status' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'priority' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'replied' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'staff_replied' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'read' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'staff_read' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'rating' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        )
    );

    public static function saveData($fields, &$id, $auto_date = true, &$errors = array())
    {
        if (trim($id) !== '' &&
            !Validate::isUnsignedInt($id) ||
            !is_array($fields) ||
            count($fields) < 0
        ) {
            return false;
        }
        if ($auto_date) {
            if ($id <= 0) {
                $fields['date_add'] = $fields['date_upd'] = date('Y-m-d H:i:s');
            } else {
                $fields['date_upd'] = date('Y-m-d H:i:s');
            }
        }
        try {
            $fields = self::setIdLangTicket($fields);
            return $id > 0 && Db::getInstance()->update('ets_hd_ticket', $fields, 'id_ets_hd_ticket=' . (int)$id) || $id <= 0 && Db::getInstance()->insert('ets_hd_ticket', $fields, true) && ($id = Db::getInstance()->Insert_ID()) > 0;
        } catch (Exception $exception) {
            $errors[] = $exception->getMessage();
        }
        return false;
    }

    public static function getAverageResponseTime($query = null)
    {
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq2 = clone $dq;
        $dq
            ->select('a.id_ets_hd_ticket, AVG(tm.response_time) `avg_response_time`')
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('ets_hd_ticket_message', 'tm', 'a.id_ets_hd_ticket = tm.id_ets_hd_ticket')
            ->where('tm.response_time > 0 AND tm.id_ets_hd_ticket_message > 0')
            ->groupBy('a.id_ets_hd_ticket');
        $sql = 'LEFT JOIN (' . $dq->build() . ') `b` ON (a.id_ets_hd_ticket = b.id_ets_hd_ticket)';
        $dq2
            ->select('AVG(b.avg_response_time)')
            ->from('ets_hd_ticket', 'a')
            ->join($sql);
        return Db::getInstance()->getValue($dq2);
    }

    public static function getMostProductSupport($query = null)
    {
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq
            ->select('a.`id_product`')
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('ets_hd_department', 'd', 'a.id_ets_hd_ticket = d.id_ets_hd_ticket')
            ->leftJoin('ets_hd_staff', 's', 's.id_ets_hd_staff = d.id_ets_hd_staff')
            //->where('d.id_ets_hd_ticket > 0')
            ->where('a.id_product > 0 ') // AND s.id_ets_hd_staff > 0 AND s.active > 0
            ->groupBy('a.`id_product`')
            ->orderBy('COUNT(DISTINCT a.id_ets_hd_ticket) DESC, COUNT(DISTINCT s.id_ets_hd_staff) DESC');

        if (HDDataProvider::tableExist('ets_czf_product')) {
            $dq
                ->select('czp.`logo` `product_logo`')
                ->leftJoin('ets_czf_product', 'czp', 'czp.`id_product` = a.`id_product`');
        }

        return Db::getInstance()->getRow($dq);
    }

    public static function getMostStaffSupport($query = null)
    {
        if($tops = self::getTopSupportStaffs($query))
        {
          return $tops[0];   
        }
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq
            ->select('
                e.id_employee
                , c.id_customer
                , IF(e.id_employee > 0, CONCAT(e.firstname, \' \', e.lastname), CONCAT(c.firstname, \' \', c.lastname)) `staff`
            ')
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('ets_hd_department', 'd', 'a.id_ets_hd_ticket = d.id_ets_hd_ticket')
            ->leftJoin('ets_hd_staff', 's', 's.id_ets_hd_staff = d.id_ets_hd_staff')
            ->leftJoin('employee', 'e', 'e.id_employee = s.id_employee')
            ->leftJoin('customer', 'c', 'c.id_customer = s.id_customer')
            ->where('d.id_ets_hd_ticket > 0')
            ->where('s.id_ets_hd_staff > 0 AND s.active > 0')
            ->groupBy('e.id_employee, c.id_customer')
            ->orderBy('COUNT(DISTINCT a.id_ets_hd_ticket) DESC, COUNT(DISTINCT s.id_ets_hd_staff) DESC')
        ;

        return Db::getInstance()->getRow($dq);
    }

    public static function queriesTickets($nb = 0, $query = null, $status_array = array())
    {
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq
            ->from('ets_hd_ticket', 'a');
        $wheres = array();
        if ($status_array) {
            if (!is_array($status_array)) {
                $status_array = explode(',', $status_array);
            }
            foreach ($status_array as $status) {
                $wheres[] = 'a.status=\'' . pSQL($status) . '\'';
            }
        }
        if ($nb) {
            if ($wheres) {
                $dq
                    ->where(implode(' OR ', $wheres));
            }
            $dq
                ->select('COUNT(*)');
            return Db::getInstance()->getValue($dq);
        }
        $dq
            ->select('COUNT(IF(a.id_ets_hd_ticket > 0, a.id_ets_hd_ticket, NULL)) `ticket`');

        $sql = $dq->build();
        $sql = preg_replace('#@JOIN@#', '1' . ($wheres ? ' AND (' . implode(' OR ', $wheres) . ')' : ''), $sql);

        return Db::getInstance()->executeS($sql);
    }

    public static function getTopSupportStaffs($query = null)
    {
        
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq
            ->select('
                e.id_employee
                , c.id_customer
                , IF(e.id_employee > 0, e.id_employee, c.id_customer) as `id`
                , IF(e.id_employee > 0, CONCAT(e.firstname, \' \', e.lastname), CONCAT(c.firstname, \' \', c.lastname)) `staff`
                , IF(s.id_employee > 0, s.avatar, IF(hc.id_customer > 0, hc.avatar, NULL)) `avatar`
                , AVG(IF(a.id_ets_hd_ticket > 0 AND a.rating >0, a.rating, NULL)) `rating_ticket`
                , COUNT(IF(a.status = "closed", a.id_ets_hd_ticket, NULL)) `closed_ticket`
                , COUNT(IF(a.status = "open", a.id_ets_hd_ticket, NULL)) `pending_ticket`
            ')
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('ets_hd_department', 'd', 'a.id_ets_hd_ticket = d.id_ets_hd_ticket')
            ->leftJoin('ets_hd_staff', 's', 's.id_ets_hd_staff = d.id_ets_hd_staff')
            ->leftJoin('employee', 'e', 'e.id_employee = s.id_employee')
            ->leftJoin('customer', 'c', 'c.id_customer = s.id_customer')
            ->leftJoin('ets_hd_customer', 'hc', 'hc.id_customer = c.id_customer')
            ->where('d.id_ets_hd_ticket > 0 AND d.default > 0')
            ->where('s.id_ets_hd_staff > 0 AND s.active > 0')
            ->groupBy('e.id_employee, c.id_customer, s.id_employee, s.avatar')
            ->orderBy('COUNT(DISTINCT a.id_ets_hd_ticket) DESC, COUNT(DISTINCT s.id_ets_hd_staff) DESC,rating_ticket DESC')
            ->limit(10);
        return Db::getInstance()->executeS($dq);
    }

    public static function getTopSupportModules($query = null, $context = null)
    {
        if ($context == null) {
            $context = Context::getContext();
        }
        if ($query == null || !$query instanceof DbQuery) {
            $dq = new DbQuery();
        } else {
            $dq = clone $query;
        }
        $dq
            ->select('a.id_product
                , pl.name `product_name`
                , pl.link_rewrite
                , GROUP_CONCAT(DISTINCT a.id_ets_hd_ticket SEPARATOR \',\') `recent_ticket`
            ')
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('ets_hd_department', 'd', 'a.id_ets_hd_ticket = d.id_ets_hd_ticket')
            ->leftJoin('ets_hd_staff', 's', 's.id_ets_hd_staff = d.id_ets_hd_staff')
            ->leftJoin('product', 'p', 'p.id_product = a.id_product')
            ->leftJoin('product_lang', 'pl', 'p.id_product = pl.id_product AND pl.id_lang=' . (int)$context->language->id)
            ->where('a.id_product > 0');

        if (HDDataProvider::tableExist('ets_czf_product')) {
            $dq
                ->select('czp.`logo` `product_logo`')
                ->leftJoin('ets_czf_product', 'czp', 'czp.`id_product` = a.`id_product`');
        }

        $dq
            ->groupBy('a.id_product, pl.name, pl.link_rewrite')
            ->orderBy('COUNT(DISTINCT a.id_ets_hd_ticket) DESC, COUNT(DISTINCT s.id_ets_hd_staff) DESC')
            ->limit(10);

        return Db::getInstance()->executeS($dq);
    }
    public static function getLogoProduct($id_product)
    {
        if (HDDataProvider::tableExist('ets_czf_product')) {
            if(($product_logo = Db::getInstance()->getValue('SELECT logo FROM `'._DB_PREFIX_.'ets_czf_product` WHERE id_product='.(int)$id_product)) && @file_exists(_PS_ROOT_DIR_ .'/'. $product_logo))
            {
                return $product_logo;
            }
        }
    }
    public static function getTicketsOf($ids)
    {
        if (!$ids ||
            !Validate::isArrayWithIds($ids)
        ) {
            return false;
        }
        $dq = new DbQuery();
        $dq
            ->select('IF(e.id_employee > 0, CONCAT(e.firstname, \' \', e.lastname), CONCAT(c.firstname, \' \', c.lastname))')
            ->from('ets_hd_department', 'd')
            ->leftJoin('ets_hd_staff', 's', 's.id_ets_hd_staff = d.id_ets_hd_staff')
            ->leftJoin('employee', 'e', 'e.id_employee = s.id_employee')
            ->leftJoin('customer', 'c', 'c.id_customer = s.id_customer')
            ->where('d.id_ets_hd_ticket IN (' . implode(',', $ids) . ')')
            ->where('d.`default` > 0')
            ->where('s.id_ets_hd_staff > 0 AND s.active > 0')
            ->groupBy('e.id_employee, c.id_customer')
            ->orderBy('COUNT(d.id_ets_hd_ticket) DESC, COUNT(d.id_ets_hd_staff) DESC');

        return Db::getInstance()->getValue($dq);
    }

    public static function getTickets($id = 0, $nb = 0, $p = 0, $n = 0, $sort_by = null, $context = null, $is_staff = false, $filters = array(), $read = null, $status_array = array(), $replied = null)
    {
        if ($context == null) {
            $context = Context::getContext();
        }
        $dq = new DbQuery();
        $dq
            ->from('ets_hd_ticket', 'a')
            ->leftJoin('customer', 'c', 'c.id_customer = a.id_customer')
            ->leftJoin('employee', 'e', 'e.id_employee = a.id_employee')
            ->leftJoin('product', 'p', 'p.id_product = a.id_product')
            ->leftJoin('product_lang', 'pl', 'p.id_product = pl.id_product AND pl.id_lang=' . (int)$context->language->id);
        if (null !== $read) {
            $dq
                ->where('a.' . ($is_staff ? 'staff_read' : 'read') . '=' . (int)$read);
        }
        if (null !== $replied) {
            $dq
                ->where('a.' . ($is_staff ? 'staff_replied' : 'replied') . '=' . (int)$replied);
        }
        if ($status_array) {
            if (!is_array($status_array)) {
                $status_array = explode(',', $status_array);
            }
            $where = array();
            foreach ($status_array as $status) {
                $where[] = 'a.status=\'' . pSQL($status) . '\'';
            }
            $dq
                ->where(implode(' OR ', $where));
        }
        if (isset($context->customer->id)
            && $context->customer->id > 0
            && $context->customer->isLogged()
        ) {
            $dq
                ->where('c.id_customer' . ($is_staff ? ' > 0 AND c.id_customer is NOT NULL' : '=' . (int)$context->customer->id));
        } elseif (isset($context->employee->id)
            && $context->employee->id > 0
            && $context->employee->isLoggedBack()
            && (int)$context->employee->id_profile !== _PS_ADMIN_PROFILE_
        ) {
            $dq
                ->where('e.id_employee=' . (int)$context->employee->id . ($is_staff ? ' OR (c.id_customer is NOT NULL AND c.id_customer > 0)' : ''));
        }

        if (is_array($filters) && count($filters) > 0) {
            foreach ($filters as $filter) {
                if (isset($filter['rules']) && $filter['rules']) {
                    foreach ($filter['rules'] as $rule) {
                        if (trim($rule) !== '')
                            $dq->where(trim($rule));
                    }
                } elseif (isset($filter['rule']) && trim($filter['rule']) !== '') {
                    $dq->where(trim($filter['rule']));
                }
            }
        }
        if ($nb) {
            $dq
                ->select('COUNT(a.id_ets_hd_ticket)');
            return (int)Db::getInstance()->getValue($dq);
        }
        if ($is_staff) {
            $dq
                ->select('
                    IF(c.id_customer > 0, CONCAT(c.firstname, \' \', c.lastname), a.customer_name) `customer`
                    , IF(c.id_customer > 0, c.email, a.customer_email) `customer_email2`
                    , c.id_customer
                ');
        }
        $dq
            ->select('a.*')
            ->select('IF(tm.date_add is NOT NULL,tm.date_add,a.date_add) as `last_date_message`, tm.message as `last_message`')
            ->select('IF(p.reference != "", CONCAT(pl.name, " (", p.reference, ")"), pl.name) as `product`, pl.link_rewrite')
            ->join('LEFT JOIN (SELECT MAX(id_ets_hd_ticket_message) as `id_ets_hd_ticket_message`, id_ets_hd_ticket FROM `' . _DB_PREFIX_ . 'ets_hd_ticket_message` GROUP BY id_ets_hd_ticket) as `tmp` ON a.id_ets_hd_ticket = tmp.id_ets_hd_ticket')
            ->leftJoin('ets_hd_ticket_message', 'tm', 'tm.id_ets_hd_ticket_message = tmp.id_ets_hd_ticket_message');
        if ($id > 0) {
            $dq
                ->where('a.id_ets_hd_ticket=' . (int)$id);
            return Db::getInstance()->getRow($dq);
        }
        if (trim($sort_by) !== '') {
            $dq->orderBy($sort_by);
        }
        if ($p > 0 && $n > 0) {
            $dq->limit($n, $n * ($p - 1));
        }
        return Db::getInstance()->executeS($dq);
    }

    public static function addColumn($column, $definition, &$errors = array())
    {
        try {
            return Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'ets_hd_ticket` ADD COLUMN `' . pSQL($column) . '` ' . pSQL($definition));
        } catch (Exception $exception) {
            $errors[] = $exception->getMessage();
        }
        return true;
    }

    public static function changeColumn($column_old, $column_new, $definition, &$errors = array())
    {
        try {
            return Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'ets_hd_ticket` CHANGE COLUMN `' . pSQL($column_old) . '` `' . pSQL($column_new) . '` ' . pSQL($definition));
        } catch (Exception $exception) {
            $errors[] = $exception->getMessage();
        }
        return true;
    }

    public static function modifyColumn($column, $definition, &$errors = array())
    {
        try {
            return Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'ets_hd_ticket` MODIFY `' . pSQL($column) . '` ' . pSQL($definition));
        } catch (Exception $exception) {
            $errors[] = $exception->getMessage();
        }
        return true;
    }

    public static function dropColumn($column)
    {
        $data_fields = HDColumn::getColumn($column) ? Db::getInstance()->executeS('SELECT `' . pSQL($column) . '` FROM `' . _DB_PREFIX_ . 'ets_hd_ticket` WHERE `' . pSQL($column) . '` is NOT NULL AND `' . pSQL($column) . '` != \'\'') : false;
        if ($exec = Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'ets_hd_ticket` DROP COLUMN `' . pSQL($column) . '`')) {
            if ($data_fields) {
                foreach ($data_fields as $data) {
                    $files = explode('|', $data);
                    if (count($files) > 1 && @file_exists(HDDefines::$default_upload . $files[0])) {
                        @unlink(HDDefines::$default_upload . $files[0]);
                    }
                }
            }
        }

        return $exec;
    }

    public function delete()
    {
        $ticket = self::getTickets($this->id);
        if ($exec = parent::delete()) {

            HDDepartment::deleteByTicket($this->id);

            if ($columns = HDColumn::getColumnFields()) {
                foreach ($columns as $column) {
                    if (isset($column['type']) && $column['type'] == 'file' && isset($column['name']) && isset($ticket[$column['name']]) && $ticket[$column['name']] !== '') {
                        $files = explode('|', $ticket[$column['name']]);
                        if (count($files) > 1 && @file_exists(HDDefines::$default_upload . $files[0])) {
                            @unlink(HDDefines::$default_upload . $files[0]);
                        }
                    }
                }
            }

            if (($messages = HDTicketMessage::getMessagesByTicket($this->id)) && HDTicketMessage::deleteMessageByTicket($this->id)) {
                foreach ($messages as $message) {
                    if (isset($message['attachment']) && trim($message['attachment']) !== '') {
                        $files = explode('|', $message['attachment']);
                        if (count($files) > 1 && @file_exists(HDDefines::$default_upload . $files[0])) {
                            @unlink(HDDefines::$default_upload . $files[0]);
                        }
                    }
                }
            }
        }

        return $exec;
    }

    public static function getSchema()
    {
        $columns = array();
        $res = Db::getInstance()->executeS('DESCRIBE `' . _DB_PREFIX_ . 'ets_hd_ticket`');
        if ($res && is_array($res) && count($res) > 0) {
            foreach ($res as $field) {
                $columns[] = trim($field['Field']);
            }
        }
        return $columns;
    }

    public static function getInstanceById($id)
    {
        $id_ets_hd_ticket = trim($id) !== '' && Validate::isUnsignedInt($id) ? $id : 0;
        return new HDTicket($id_ets_hd_ticket);
    }

    /**
     * @param $id_ets_hd_ticket
     * @param Context $context
     * @return bool
     */
    public static function isGranted($id_ets_hd_ticket, $context = null)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return false;
        }
        if ($context == null) {
            $context = Context::getContext();
        }
        $ticket = self::getInstanceById($id_ets_hd_ticket);
        return $ticket->id > 0 &&
            (isset($context->employee->id)
                && $context->employee->id > 0
                && $context->employee->isLoggedBack()
                && ($context->employee->id_profile == _PS_ADMIN_PROFILE_ || (int)$ticket->id_employee > 0 && (int)$ticket->id_employee == $context->employee->id || HDStaff::isGranted(0, $context->employee->id)) ||
                isset($context->customer->id)
                && $context->customer->id > 0
                && $context->customer->isLogged()
                && ((int)$ticket->id_customer > 0 && (int)$ticket->id_customer == $context->customer->id || HDStaff::isGranted($context->customer->id))
            );
    }

    public static function read($id_ets_hd_ticket, $is_staff = false)
    {
        if (!$id_ets_hd_ticket ||
            !Validate::isUnsignedInt($id_ets_hd_ticket)
        ) {
            return false;
        }
        $ticket = self::getInstanceById($id_ets_hd_ticket);
        if ($is_staff) {
            $ticket->staff_read = 1;
        } else
            $ticket->read = 1;

        return $ticket->save();
    }

    public static function updateFieldByIds($ids_ets_hd_ticket, $field, $value)
    {
        if (!$ids_ets_hd_ticket ||
            !Validate::isArrayWithIds($ids_ets_hd_ticket) ||
            !$field ||
            !Validate::isCleanHtml($field)
        ) {
            return false;
        }

        return Db::getInstance()->update('ets_hd_ticket', array($field => $value), 'id_ets_hd_ticket IN (' . implode(',', $ids_ets_hd_ticket) . ')');
    }

    public static function deleteByIds($ids_ets_hd_ticket)
    {
        if (!$ids_ets_hd_ticket ||
            !Validate::isArrayWithIds($ids_ets_hd_ticket)
        ) {
            return false;
        }
        foreach ($ids_ets_hd_ticket as $id) {
            $ticket = new HDTicket($id);
            if (!$ticket->delete()) {
                return false;
            }
        }
        return true;
    }

    public static function orderReferenceAndEmail($reference, $email)
    {
        $sql = '
          SELECT id_order
            FROM `' . _DB_PREFIX_ . 'orders` o
            LEFT JOIN `' . _DB_PREFIX_ . 'customer` c ON (o.`id_customer` = c.`id_customer`)
                WHERE o.`reference` = \'' . pSQL($reference) . '\' AND c.`email` = \'' . pSQL($email) . '\'
        ';

        $id = (int) Db::getInstance()->getValue($sql);

        return new Order($id);
    }

    public static function setIdLangTicket($fields)
    {
        if (!isset($fields['id_lang']) || !$fields['id_lang']){
            $context = Context::getContext();
            $fields['id_lang'] = 0;
            if (defined('_PS_ADMIN_DIR_') && isset($context->employee) && $fields['id_customer']){
                $customer = new Customer($fields['id_customer']);
                $fields['id_lang'] = $customer->id_lang;
            }
            else{
                $fields['id_lang'] = $context->language->id;
            }
        }
        return $fields;
    }
}