<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDStaff extends ObjectModel
{
    public $id;
    public $id_employee;
    public $id_customer;
    public $nick_name;
    public $avatar;
    public $avatar_old;
    public $signature;
    public $active;
    public $email;

    public static $definition = array(
        'table' => 'ets_hd_staff',
        'primary' => 'id_ets_hd_staff',
        'fields' => array(
            'id_customer' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_employee' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'nick_name' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'avatar' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'signature' => array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'active' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
        )
    );

    public static function initialized()
    {
        $dq = new DbQuery();
        $dq
            ->select('id_employee')
            ->from('employee', 'e')
            ->where('id_profile=' . (int)_PS_ADMIN_PROFILE_);
        $id_employee = (int)Db::getInstance()->getValue($dq);
        if ($id_employee > 0) {
            $obj = new self();
            $obj->id_employee = $id_employee;
            $obj->active = 1;
            $obj->add(true);
        }
    }

    /**
     * @param int $id_customer
     * @param int $id_employee
     * @return false|string|null
     */
    public static function isGranted($id_customer = 0, $id_employee = 0)
    {
        $dq = new DbQuery();
        $dq
            ->from('ets_hd_staff')
            ->where('active=1');
        if ($id_customer > 0) {
            $dq
                ->select('id_customer')
                ->where('id_customer=' . (int)$id_customer);
        } elseif ($id_employee > 0) {
            $dq
                ->select('id_employee')
                ->where('id_employee=' . (int)$id_employee);
        }
        return (int)Db::getInstance()->getValue($dq);
    }

    /**
     * @param false|array $ids
     * @return array|bool|mysqli_result|PDOStatement|resource|null
     */
    public static function getCustomers($ids = false)
    {
        $dq = new DbQuery();
        $dq
            ->from('ets_hd_staff', 'a')
            ->where('a.id_customer is NOT NULL AND a.id_customer > 0');
        if ($ids) {
            $dq
                ->select('a.id_customer');
            if (is_array($ids) && Validate::isArrayWithIds($ids)) {
                $dq
                    ->where('a.id_customer IN (' . implode(',', $ids) . ')');
            }
        } else {
            $dq
                ->select('a.* , c.*, CONCAT(c.firstname, " ", c.lastname) `customer`')
                ->leftJoin('customer', 'c', 'a.id_customer = c.id_customer');
        }

        return Db::getInstance()->executeS($dq);
    }

    public static function addCustomer($ids_customer = array())
    {
        if (!$ids_customer || !is_array($ids_customer) || !Validate::isArrayWithIds($ids_customer)) {
            return false;
        }
        if (self::deleteCustomer($ids_customer)) {
            $customers = self::getCustomers($ids_customer);

            $ids_customer_exits = array();
            if (is_array($customers) && count($customers) > 0) {
                foreach ($customers as $customer) {
                    $ids_customer_exits[] = (int)$customer['id_customer'];
                }
            }
            $customer_diff = array_diff($ids_customer, $ids_customer_exits);
            if ($customer_diff) {
                $data = array();
                foreach ($customer_diff as $id_customer) {
                    $data[] = array(
                        'id_customer' => $id_customer,
                        'id_employee' => 0,
                        'active' => 1,
                    );
                }
                if ($data) {
                    return Db::getInstance()->insert('ets_hd_staff', $data);
                }
            }
        }

        return true;
    }

    public static function deleteAllCustomer()
    {
        return Db::getInstance()->delete('ets_hd_staff', '(id_employee is NULL OR id_employee <= 0)');
    }

    public static function deleteCustomer($ids_customer = array())
    {
        if (!$ids_customer || !is_array($ids_customer) || !Validate::isArrayWithIds($ids_customer)) {
            return false;
        }

        return Db::getInstance()->delete('ets_hd_staff', 'id_customer NOT IN (' . implode(',', $ids_customer) . ') AND (id_employee is NULL OR id_employee <= 0)');
    }

    public static function getIdStaffByIdEmployee($id_employee)
    {
        if ($id_employee <= 0 ||
            !Validate::isUnsignedInt($id_employee)
        ) {
            return 0;
        }
        $dq = new DbQuery();
        $dq
            ->select('id_ets_hd_staff')
            ->from('ets_hd_staff')
            ->where('id_employee=' . (int)$id_employee);

        return (int)Db::getInstance()->getValue($dq);
    }

    public static function getIdStaffByIdCustomer($id_customer)
    {
        if ($id_customer <= 0 ||
            !Validate::isUnsignedInt($id_customer)
        ) {
            return 0;
        }
        $dq = new DbQuery();
        $dq
            ->select('id_ets_hd_staff')
            ->from('ets_hd_staff')
            ->where('id_customer=' . (int)$id_customer);

        return (int)Db::getInstance()->getValue($dq);
    }

    public static function getEmployees($exclude_supper_admin = true)
    {
        $dq = new DbQuery();
        $dq
            ->select('hs.*, e.*, CONCAT(e.firstname, " ", e.lastname) `employee`')
            ->from('employee', 'e')
            ->leftJoin('ets_hd_staff', 'hs', 'hs.id_employee = e.id_employee')
            ->where('hs.active = 1')
            ->where('hs.id_employee > 0');
        if ($exclude_supper_admin) {
            $dq
                ->where('e.id_profile !=' . _PS_ADMIN_PROFILE_);
        }

        return Db::getInstance()->executeS($dq);
    }
}