<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

if (!defined('_PS_VERSION_'))
    exit;

class HDLink
{
    static $_INSTANCE;
    public $ssl_enable;

    public function __construct()
    {
        $this->ssl_enable = Configuration::get('PS_SSL_ENABLED');
    }

    public static function getInstance()
    {
        if (!self::$_INSTANCE) {
            self::$_INSTANCE = new HDLink();
        }

        return self::$_INSTANCE;
    }

    public function getBaseLink($idShop = null, $ssl = null, $relativeProtocol = false)
    {
        if (null === $ssl) {
            $ssl = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'));
        }

        if (Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE') && $idShop !== null) {
            $shop = new Shop($idShop);
        } else {
            $shop = Context::getContext()->shop;
        }

        if ($relativeProtocol) {
            $base = '//' . ($ssl && $this->ssl_enable ? $shop->domain_ssl : $shop->domain);
        } else {
            $base = (($ssl && $this->ssl_enable) ? 'https://' . $shop->domain_ssl : 'http://' . $shop->domain);
        }

        return $base . $shop->getBaseURI();
    }

    public function getLangLink($idLang = null, Context $context = null, $idShop = null)
    {
        static $psRewritingSettings = null;
        if ($psRewritingSettings === null) {
            $psRewritingSettings = (int)Configuration::get('PS_REWRITING_SETTINGS', null, null, $idShop);
        }

        if ($context == null) {
            $context = Context::getContext();
        }

        if ((!(int)Configuration::get('PS_REWRITING_SETTINGS') && in_array($idShop, [$context->shop->id, null])) || !Language::isMultiLanguageActivated($idShop) || !$psRewritingSettings) {
            return '';
        }

        if (!$idLang) {
            $idLang = $context->language->id;
        }

        return Language::getIsoById($idLang) . '/';
    }

    /**
     * @param $route
     * @param array $params
     * @param null $idLang
     * @param null $idShop
     * @param false $relativeProtocol
     * @return string
     */
    public function getLinkRewrite($route, $params = [], $idLang = null, $idShop = null, $relativeProtocol = false)
    {
        if (!$idLang) {
            $idLang = Context::getContext()->language->id;
        }
        return $this->getBaseLink($idShop, null, $relativeProtocol)
            . $this->getLangLink($idLang, null, $idShop)
            . Dispatcher::getInstance()->createUrl($route, $idLang, $params, (int)Configuration::get('PS_REWRITING_SETTINGS'), '', $idShop);
    }

    public function getAddTicketLink($idLang, $params = array())
    {
        if (!isset($params['rewrite']) ||
            trim($params['rewrite']) == ''
        ) {
            $params['rewrite'] = trim(Configuration::get('ETS_HD_TICKET_URL_ALIAS', $idLang)) ?: 'support-ticket';
        }
        return $this->getLinkRewrite('module-ets_helpdesk-add', $params, $idLang);
    }

    public function getTicketsLink($idLang, $params = array())
    {
        if (isset($params['staff']) && $params['staff']) {
            unset($params['staff']);

            return $this->getStaffsLink($idLang, $params);
        }
        if (!isset($params['rewrite']) ||
            trim($params['rewrite']) == ''
        ) {
            $params['rewrite'] = trim(Configuration::get('ETS_HD_TICKET_URL_ALIAS', $idLang)) ?: 'support-ticket';
        }
        return $this->getLinkRewrite('module-ets_helpdesk-tickets', $params, $idLang);
    }

    public function getTicketLink($idLang, $params = array())
    {
        if (isset($params['staff']) && $params['staff']) {
            unset($params['staff']);

            return $this->getStaffLink($idLang, $params);
        }
        if (!isset($params['rewrite']) ||
            trim($params['rewrite']) == ''
        ) {
            $params['rewrite'] = trim(Configuration::get('ETS_HD_TICKET_URL_ALIAS', $idLang)) ?: 'support-ticket';
        }
        return $this->getLinkRewrite('module-ets_helpdesk-ticket', $params, $idLang);
    }

    public function getStaffsLink($idLang, $params = array())
    {
        if (!isset($params['rewrite']) ||
            trim($params['rewrite']) == ''
        ) {
            $params['rewrite'] = trim(Configuration::get('ETS_HD_STAFF_URL_ALIAS', $idLang)) ?: 'support-staff';
        }
        return $this->getLinkRewrite('module-ets_helpdesk-staffs', $params, $idLang);
    }

    public function getStaffLink($idLang, $params = array())
    {
        if (!isset($params['rewrite']) ||
            trim($params['rewrite']) == ''
        ) {
            $params['rewrite'] = trim(Configuration::get('ETS_HD_STAFF_URL_ALIAS', $idLang)) ?: 'support-staff';
        }
        return $this->getLinkRewrite('module-ets_helpdesk-staff', $params, $idLang);
    }

    public function getProcessLink($idLang, $params = array())
    {
        return $this->getLinkRewrite('module-ets_helpdesk-process', $params, $idLang);
    }

    /**
     * @param $route_id
     * @param array $params
     * @param null $idLang
     * @param null $idShop
     * @param false $relativeProtocol
     * @return string
     * @throws PrestaShopException
     */
    public function getPaginationLink($route_id, $params = array(), $idLang = null, $idShop = null, $relativeProtocol = false)
    {
        if (!$idLang) {
            $idLang = Context::getContext()->language->id;
        }

        return
            $this->getBaseLink($idShop, null, $relativeProtocol)
            . $this->getLangLink($idLang, null, $idShop)
            . Dispatcher::getInstance()->createUrl($route_id, $idLang, $params, (int)Configuration::get('PS_REWRITING_SETTINGS'), '', $idShop);
    }

    /**
     * @param $route_id
     * @param $total
     * @param $p
     * @param $n
     * @param array $params
     * @param int $number_links
     * @return array
     * @throws PrestaShopException
     */
    public function getPagination($route_id, $total, $p, $n, $params = array(), $number_links = 7, $admin_controller = null)
    {
        if ($p <= 0)
            $p = 1;
        if ($n <= 0)
            $n = 10;

        $last = (int)ceil($total / $n);
        $start = (($p - $number_links) > 0) ? $p - $number_links : 1;
        $end = (($p + $number_links) < $last) ? $p + $number_links : $last;
        $paginates = [];
        $paginates[] = [
            'class' => $p <= 1 ? 'disabled' : '',
            'page' => 1,
            'icon' => 'angle-double-left'
        ];
        $paginates[] = [
            'class' => ($p == 1) ? 'disabled' : '',
            'page' => ($p - 1),
            'icon' => 'angle-left'
        ];
        if ($start > 1) {
            $paginates[] = [
                'class' => '',
                'page' => 1,
                'title' => '1'
            ];
            if ($start > 2) {
                $paginates[] = [
                    'class' => '',
                    'page' => $start - 1,
                    'title' => '...'
                ];
            }
        }
        for ($i = $start; $i <= $end; $i++) {
            $paginates[] = [
                'class' => ($p == $i) ? 'active' : '',
                'page' => $i,
                'title' => $i
            ];
        }
        if ($end < $last) {
            if ($end < ($last - 1)) {
                $paginates[] = [
                    'class' => '',
                    'page' => $end + 1,
                    'title' => '...'
                ];
            }
            $paginates[] = [
                'class' => '',
                'page' => $last,
                'title' => $last
            ];
        }
        $paginates[] = [
            'class' => ($p == $last) ? 'disabled' : '',
            'page' => ($p + 1),
            'icon' => 'angle-right'
        ];
        $paginates[] = [
            'class' => ($p == $last) ? 'disabled' : '',
            'page' => $last,
            'icon' => 'angle-double-right'
        ];
        if ($paginates) {
            foreach ($paginates as &$paginate) {
                if ($paginate['page'] > 0 && (int)$paginate['page'] <= $last && $paginate['page'] !== $p && $paginate['class'] !== 'disabled') {
                    $paginate['link'] = $admin_controller !== null ? Context::getContext()->link->getAdminLink($admin_controller) . '&' . http_build_query(array_merge($params, array('n' => $n, 'p' => (int)$paginate['page']))) : $this->getPaginationLink($route_id, array_merge($params, array('n' => $n, 'p' => (int)$paginate['page'])));
                }
            }
        }

        return $paginates;
    }

    public function getDownloadLink($idLang, $params = array())
    {
        if (isset($params['type']) && $params['type']) {
            $params['type'] = Tools::str2url($params['type']);
        }
        if (isset($params['name']) && $params['name']) {
            $params['name'] = Tools::str2url($params['name']);
        }
        return $this->getLinkRewrite('module-ets_helpdesk-download', $params, $idLang);
    }
}