<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDDepartment extends ObjectModel
{
    public $id_ets_hd_ticket;
    public $id_ets_hd_staff;
    public $default;

    public static $definition = array(
        'table' => 'ets_hd_department',
        'primary' => 'id_ets_hd_ticket',
        'fields' => array(
            'id_ets_hd_ticket' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_ets_hd_staff' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'default' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
        )
    );

    public static function saveData($id_ets_hd_ticket, $id_ets_hd_staff, $default = 0)
    {
        return ((int)$default <= 0 || (bool)Db::getInstance()->update('ets_hd_department', array('default' => null), 'id_ets_hd_ticket=' . (int)$id_ets_hd_ticket, 0, true))
            && Db::getInstance()->insert(
                'ets_hd_department'
                , array(
                    'id_ets_hd_ticket' => (int)$id_ets_hd_ticket,
                    'id_ets_hd_staff' => (int)$id_ets_hd_staff,
                    'default' => (int)$default > 0 ? (int)$default : null
                )
                , true, false, Db::ON_DUPLICATE_KEY
            );
    }

    public static function deleteByTicket($id_ets_hd_ticket)
    {
        if (!$id_ets_hd_ticket || !Validate::isUnsignedInt($id_ets_hd_ticket)) {
            return false;
        }

        return Db::getInstance()->delete('ets_hd_department', 'id_ets_hd_ticket=' . (int)$id_ets_hd_ticket);
    }
}