<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDDefines extends HDTranslate
{
    static $_INSTANCE;
    static $_quickTabs = array();
    static $default_upload = _PS_DOWNLOAD_DIR_ . 'ets_helpdesk/';
    static $avatar_upload = _PS_IMG_DIR_ . 'ets_helpdesk/avatar/';
    static $avatar_base_uri = _PS_IMG_ . 'ets_helpdesk/avatar/';
    static $customer_avatar_default = 'customer_avatar_default.jpg';
    static $employee_avatar_default = 'employee_avatar_default.jpg';
    static $image_dir = __PS_BASE_URI__ . 'modules/ets_helpdesk/views/img/';

    public static function getInstance()
    {
        if (!self::$_INSTANCE) {
            self::$_INSTANCE = new HDDefines();
        }
        return self::$_INSTANCE;
    }

    public function getAllConfigs()
    {
        return array_merge($this->getConfigs(), $this->getConfigsCronjob());
    }

    public function getConfigs()
    {
        $languages = Language::getLanguages();
        $friend_urls = $friend_staff_urls = array();
        if ($languages) {
            foreach ($languages as $language) {
                $friend_urls[$language['id_lang']] = HDLink::getInstance()->getAddTicketLink($language['id_lang'], array('rewrite' => Tools::getValue('ETS_HD_TICKET_URL_ALIAS_' . $language['id_lang'])));
                $friend_staff_urls[$language['id_lang']] = HDLink::getInstance()->getStaffsLink($language['id_lang'], array('rewrite' => Tools::getValue('ETS_HD_STAFF_URL_ALIAS_' . $language['id_lang'])));
            }
        }

        return array(
            // Info
            'ETS_HD_TICKET_ENABLED' => array(
                'type' => 'switch',
                'label' => $this->l('Enable ticketing system'),
                'default' => 1,
                'validate' => 'isBool',
                'form_group_class' => 'enable_ticket',
                'js' => 'int',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_TITLE' => array(
                'type' => 'text',
                'label' => $this->l('Form title'),
                'lang' => true,
                'required' => true,
                'validate' => 'isCleanHtml',
                'size' => 128,
                'default' => array(
                    'origin' => 'Support ticket',
                    'trans' => $this->l('Support ticket'),
                ),
                'group' => 'info',
            ),
            'ETS_HD_TICKET_URL_ALIAS' => array(
                'type' => 'text',
                'label' => $this->l('Support URL alias'),
                'lang' => true,
                'required' => true,
                'friend_urls' => $friend_urls,
                'validate' => 'isCleanHtml',
                'default' => 'support-ticket',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_URL_SUFFIX' => array(
                'type' => 'switch',
                'label' => $this->l('Use URL suffix'),
                'desc' => $this->l('Enable to add ".html" to the end of URLs'),
                'default' => 0,
                'validate' => 'isBool',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_DESCRIPTION' => array(
                'type' => 'textarea',
                'label' => $this->l('Description'),
                'lang' => true,
                'default' => $this->l('Form for technical support submit'),
                'validate' => 'isCleanHtml',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_META_TITLE' => array(
                'type' => 'text',
                'label' => $this->l('Meta title'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_META_DESCRIPTION' => array(
                'type' => 'textarea',
                'label' => $this->l('Meta description'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'info',
            ),
            'ETS_HD_TICKET_META_KEYWORDS' => array(
                'type' => 'tags',
                'label' => $this->l('Meta keywords'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'info',
            ),
            // End Info

            // Field
            'ETS_HD_TICKET_FIELD_LIST' => array(
                'type' => 'html',
                'label' => $this->l('Field list'),
                'lang' => true,
                'group' => 'field',
            ),
            // End Field

            // General
            'ETS_HD_ALLOW_USER_SUBMIT' => array(
                'type' => 'switch',
                'label' => $this->l('Allow unregistered users to submit ticket?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'general',
            ),
            'ETS_HD_STAFF_UPLOAD_FILE' => array(
                'type' => 'switch',
                'label' => $this->l('Allow staff to upload file?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'general',
            ),
            'ETS_HD_SAVE_STAFF_FILE' => array(
                'type' => 'switch',
                'label' => $this->l('Save staff\'s upload file?'),
                'default' => 1,
                'validate' => 'isBool',
                'desc' => $this->l('Enable this to save staff\'s upload file on the server. Otherwise the upload file will only be sent to customer via email.'),
                'group' => 'general',
            ),
            'ETS_HD_CUSTOMER_REPLY_UPLOAD_FILE' => array(
                'type' => 'switch',
                'label' => $this->l('Allow customer to attach file when reply to a ticket'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'general',
            ),
            'ETS_HD_SAVE_CUSTOMER_FILE' => array(
                'type' => 'switch',
                'label' => $this->l('Save customer\'s upload file?'),
                'default' => 1,
                'validate' => 'isBool',
                'desc' => $this->l(' Enable this to save customer\'s upload file on the server. Otherwise the upload file will only be sent to admin via email.'),
                'group' => 'general',
            ),
            'ETS_HD_ALLOW_CAPTCHA' => array(
                'type' => 'switch',
                'label' => $this->l('Enable CAPTCHA protection?'),
                'default' => 0,
                'validate' => 'isBool',
                'js' => 'int',
                'group' => 'general',
            ),
            'ETS_HD_CUSTOMER_NO_CAPTCHA' => array(
                'type' => 'switch',
                'label' => $this->l('Do not require registered user to enter captcha code'),
                'default' => 0,
                'validate' => 'isBool',
                'form_group_class' => 'captcha',
                'js' => 'int',
                'group' => 'general',
            ),
            'ETS_HD_CAPTCHA_TYPE' => array(
                'type' => 'select',
                'label' => $this->l('Captcha type'),
                'options' => array(
                    'query' => array(
                        array(
                            'id_option' => 'recaptcha_v2',
                            'name' => $this->l('Google reCAPTCHA v2')
                        ),
                        array(
                            'id_option' => 'recaptcha_v3',
                            'name' => $this->l('Google reCAPTCHA v3')
                        ),
                    ),
                    'id' => 'id_option',
                    'name' => 'name'
                ),
                'js' => 'string',
                'default' => 'image',
                'form_group_class' => 'captcha',
                'group' => 'general',
            ),
            'ETS_HD_RECAPTCHA_V2_SITE_KEY' => array(
                'type' => 'text',
                'label' => $this->l('Site key v2'),
                'validate' => 'isCleanHtml',
                'required' => true,
                'condition' => array(
                    'ETS_HD_ALLOW_CAPTCHA' => '1',
                    'ETS_HD_CAPTCHA_TYPE' => 'recaptcha_v2',
                ),
                'form_group_class' => 'captcha google recaptcha_v2',
                'js' => 'string',
                'group' => 'general',
            ),
            'ETS_HD_RECAPTCHA_V2_SECRET_KEY' => array(
                'type' => 'text',
                'label' => $this->l('Secret key v2'),
                'validate' => 'isCleanHtml',
                'required' => true,
                'condition' => array(
                    'ETS_HD_ALLOW_CAPTCHA' => '1',
                    'ETS_HD_CAPTCHA_TYPE' => 'recaptcha_v2',
                ),
                'form_group_class' => 'captcha google recaptcha_v2',
                'group' => 'general',
            ),
            'ETS_HD_RECAPTCHA_V3_SITE_KEY' => array(
                'type' => 'text',
                'label' => $this->l('Site key v3'),
                'validate' => 'isCleanHtml',
                'required' => true,
                'condition' => array(
                    'ETS_HD_ALLOW_CAPTCHA' => '1',
                    'ETS_HD_CAPTCHA_TYPE' => 'recaptcha_v3',
                ),
                'form_group_class' => 'captcha google recaptcha_v3',
                'js' => 'string',
                'group' => 'general',
            ),
            'ETS_HD_RECAPTCHA_V3_SECRET_KEY' => array(
                'type' => 'text',
                'label' => $this->l('Secret key v3'),
                'validate' => 'isCleanHtml',
                'required' => true,
                'condition' => array(
                    'ETS_HD_ALLOW_CAPTCHA' => '1',
                    'ETS_HD_CAPTCHA_TYPE' => 'recaptcha_v3',
                ),
                'form_group_class' => 'captcha google recaptcha_v3',
                'group' => 'general',
            ),
            'ETS_HD_DEFAULT_PRIORITY' => array(
                'type' => 'select',
                'label' => $this->l('Default priority'),
                'options' => array(
                    'query' => $this->getOptionPriority(),
                    'id' => 'id',
                    'name' => 'name'
                ),
                'default' => 'medium',
                'group' => 'general',
            ),
            'ETS_HD_BUTTON_SUBMIT_LABEL' => array(
                'type' => 'text',
                'label' => $this->l('Submit button label'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'js' => 'string',
                'group' => 'general',
                'form_group_class' => 'hd_submit_label',
                'default' => array(
                    'origin' => 'Submit',
                    'trans' => $this->l('Submit'),
                ),
                'desc' => $this->l('Leaving blank will get the label by default is "Submit" '),
            ),
            // End General

            // Condition
            'ETS_HD_TICKET_CLOSING_TIME' => array(
                'type' => 'text',
                'label' => $this->l('Ticket will be automatically closed if there is no response from customer after X days'),
                'suffix' => $this->l('day(s)'),
                'desc' => $this->l('Leave this field blank to not limit the support ticket closing time '),
                'col' => 3,
                'form_group_class' => 'ticket_close_time',
                'validate' => 'isUnsignedInt',
                'group' => 'condition',
                'default' => 7,
            ),
            'ETS_HD_PRODUCTS_IN_LIST_TICKET' => array(
                'type' => 'switch',
                'label' => $this->l('Display products in list ticket'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'condition',
            ),
            'ETS_HD_NUMBER_TICKET_MESSAGES' => array(
                'type' => 'text',
                'label' => $this->l('Number of messages to display'),
                'desc' => $this->l('Leave blank to display all messages'),
                'default' => 10,
                'form_group_class' => 'number_ticket_messages',
                'validate' => 'isUnsignedInt',
                'group' => 'condition',
            ),
            'ETS_HD_EMPLOYEE_AVATAR_DEFAULT' => array(
                'type' => 'file',
                'label' => $this->l('Default employee avatar'),
                'validate' => 'isFileName',
                'folder' => self::$avatar_upload,
                'base_uri' => self::$avatar_base_uri,
                'reader' => true,
                'default_image' => self::$image_dir . self::$employee_avatar_default,
                'group' => 'condition',
            ),
            'ETS_HD_CUSTOMER_AVATAR_DEFAULT' => array(
                'type' => 'file',
                'label' => $this->l('Default customer avatar'),
                'validate' => 'isFileName',
                'folder' => self::$avatar_upload,
                'base_uri' => self::$avatar_base_uri,
                'reader' => true,
                'default_image' => self::$image_dir . self::$employee_avatar_default,
                'group' => 'condition',
            ),
            'ETS_HD_CLEAR_FILE_UPLOAD' => array(
                'type' => 'select',
                'label' => $this->l('Clear file upload'),
                'options' => array(
                    'query' => $this->getOptionTimes(),
                    'id' => 'id_option',
                    'name' => 'name'
                ),
                'validate' => 'isCleanHtml',
                'group' => 'condition',
            ),
            'ETS_HD_TIME_RELOAD_LIST_TICKET' => array(
                'type' => 'text',
                'label' => $this->l('Automatically reload tickets after X minute(s)'),
                'validate' => 'isUnsignedFloat',
                'group' => 'condition',
                'suffix'=> $this->l('minute(s)'),
                'desc' => $this->l('Leave it blank and auto mode won\'t work'),
                'default'=>5,
                'col'=>3,
            ),
            'ETS_HD_TIME_RELOAD_LIST_TICKET_FRONT' => array(
                'type' => 'text',
                'label' => $this->l('Automatically reload tickets in front end after X minute(s)'),
                'validate' => 'isUnsignedFloat',
                'group' => 'condition',
                'suffix'=> $this->l('minute(s)'),
                'desc' => $this->l('Leave it blank and auto mode won\'t work'),
                'default'=>5,
                'col'=>3,
            ),
            'ETS_HD_TIME_RELOAD_LIST_MESSAGE' => array(
                'type' => 'text',
                'label' => $this->l('Automatically reload message tickets after x minute(s)'),
                'validate' => 'isUnsignedFloat',
                'group' => 'condition',
                'suffix'=> $this->l('minute(s)'),
                'desc' => $this->l('Leave it blank and auto mode won\'t work'),
                'default'=>5,
                'col'=>3,
            ),
            'ETS_HD_TIME_RELOAD_LIST_MESSAGE_FRONT' => array(
                'type' => 'text',
                'label' => $this->l('Automatically reload message tickets of front end after x minute(s)'),
                'validate' => 'isUnsignedFloat',
                'group' => 'condition',
                'suffix'=> $this->l('minute(s)'),
                'desc' => $this->l('Leave it blank and auto mode won\'t work'),
                'default'=>5,
                'col'=>3,
            ),
            
            // End Condition

            // Staff
            'ETS_HD_STAFF_TITLE' => array(
                'type' => 'text',
                'label' => $this->l('Form title'),
                'lang' => true,
                'required' => true,
                'validate' => 'isCleanHtml',
                'default' => array(
                    'origin' => 'Support staff',
                    'trans' => $this->l('Support staff'),
                ),
                'group' => 'staff',
            ),
            'ETS_HD_STAFF_URL_ALIAS' => array(
                'type' => 'text',
                'label' => $this->l('Support URL alias'),
                'lang' => true,
                'required' => true,
                'friend_urls' => $friend_staff_urls,
                'validate' => 'isCleanHtml',
                'default' => 'support-staff',
                'group' => 'staff',
            ),
            'ETS_HD_STAFF_DESCRIPTION' => array(
                'type' => 'textarea',
                'label' => $this->l('Description'),
                'lang' => true,
                'default' => $this->l('Form for technical support submit'),
                'validate' => 'isCleanHtml',
                'group' => 'staff',
            ),
            'ETS_HD_STAFF_META_TITLE' => array(
                'type' => 'text',
                'label' => $this->l('Meta title'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'staff',
            ),
            'ETS_HD_STAFF_META_DESCRIPTION' => array(
                'type' => 'textarea',
                'label' => $this->l('Meta description'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'staff',
            ),
            'ETS_HD_STAFF_META_KEYWORDS' => array(
                'type' => 'tags',
                'label' => $this->l('Meta keywords'),
                'lang' => true,
                'validate' => 'isCleanHtml',
                'group' => 'staff',
            ),
            // End Staff

            // Email
            'ETS_HD_SEND_FROM_EMAIL' => array(
                'type' => 'text',
                'label' => $this->l('Send from email'),
                'validate' => 'isCleanHtml',
                'desc' => sprintf($this->l('*Note: custom "From email" doesn\'t support Gmail smtp service as Gmail forces "From email" to your SMTP username (%s)'),Configuration::get('PS_MAIL_USER') ? : Configuration::get('PS_SHOP_EMAIL')),
                'group' => 'email',
            ),
            'ETS_HD_SEND_FROM_NAME' => array(
                'type' => 'text',
                'label' => $this->l('Send from name'),
                'validate' => 'isCleanHtml',
                'group' => 'email',
            ),
            'ETS_HD_WHEN_SEND_MAIL' => array(
                'type' => 'radio',
                'group' => 'email',
                'label' => $this->l('When to send email?'),
                'default' => 'by_queue',
                'values' => array(
                    array(
                        'id'=>'ETS_HD_WHEN_SEND_MAIL_by_queue',
                        'label' => $this->l('Send by queue'),
                        'value' => 'by_queue',
                    ),
                    array(
                        'id'=>'ETS_HD_WHEN_SEND_MAIL_immediately',
                        'label' => $this->l('Send immediately'),
                        'value' => 'immediately',
                    ),
                ),
            ),
            'ETS_HD_DIRECTORY_ADMIN_URL' => array(
                'type' => 'text',
                'label' => $this->l('Admin directory'),
                'group' => 'email',
                'desc' => Tools::getShopDomainSsl(true) . Context::getContext()->shop->getBaseURI() . '[admin-directory]',
                'default' => basename(getcwd()),
            ),
            'ETS_HD_MAIL_NEW_TICKET' => array(
                'type' => 'checkbox',
                'label' => $this->l('Who to send email notification when a new ticket arrived?'),
                'values' => array(
                    'query' => array(
                        array(
                            'id' => 'supper_admins',
                            'label' => $this->l('Super admins'),
                        ),
                        array(
                            'id' => 'all_staff',
                            'label' => $this->l('All staff'),
                        ),
                        array(
                            'id' => 'custom_emails',
                            'label' => $this->l('Custom emails'),
                        )
                    ),
                    'id' => 'id',
                    'name' => 'label',
                ),
                'default' => 'supper_admins',
                'form_group_class' => 'mail_new_ticket',
                'group_title' => $this->l('Send email to admin'),
                'group' => 'email',
            ),
            'ETS_HD_CUSTOM_EMAILS' => array(
                'type' => 'text',
                'label' => $this->l('Custom emails'),
                'name' => 'custom_mail',
                'form_group_class' => 'mail_new_ticket custom_emails',
                'required' => true,
                'condition' => array(
                    'ETS_HD_MAIL_NEW_TICKET' => array(
                        array(
                            'operator' => 'in_array',
                            'value' => 'custom_emails'
                        )
                    ),
                ),
                'validate' => 'isListEmail',
                'desc' => $this->l('Enter email separated by a comma (,)'),
                'group' => 'email',
            ),
            'ETS_HD_MAIL_REPLY_ADMIN' => array(
                'type' => 'switch',
                'label' => $this->l('Send email to admin when customer reply to a ticket?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'email',
            ),
            'ETS_HD_MAIL_TO_ADMIN_REPLIED' => array(
                'type' => 'switch',
                'label' => $this->l('Send email to admin when they successfully replied?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'email',
            ),
            'ETS_HD_MAIL_TO_ADMIN_EDIT_TICKET' => array(
                'type' => 'switch',
                'label' => $this->l('Send email to admin when customer edit to a ticket?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'email',
            ),
            'ETS_HD_MAIL_TO_CUSTOMER' => array(
                'type' => 'switch',
                'label' => $this->l('Send a confirmation email to customer when ticket is submitted?'),
                'default' => 1,
                'validate' => 'isBool',
                'group_title' => $this->l('Send email to customer'),
                'group' => 'email',
            ),
            'ETS_HD_MAIL_REPLY_CUSTOMER' => array(
                'type' => 'switch',
                'label' => $this->l('Send email to customer when admin reply to their ticket?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'email',
            ),
            'ETS_HD_MAIL_TO_CUSTOMER_REPLIED' => array(
                'type' => 'switch',
                'label' => $this->l('Send email to customer when they successfully replied?'),
                'default' => 1,
                'validate' => 'isBool',
                'group' => 'email',
            ),
            // End Email
        );
    }

    static $cache_options_time = array();

    public function getOptionTimes($option = null, $use_cache = true)
    {
        if (!$use_cache) {
            self::$cache_options_time = array();
        }
        if (!self::$cache_options_time) {
            self::$cache_options_time = array(
                'everything' => array(
                    'id_option' => 'everything',
                    'value' => 0,
                    'name' => $this->l('Everything') . ' ' . $this->getFilesByTime(),
                ),
                'one_week_old' => array(
                    'id_option' => 'one_week_old',
                    'value' => ($one_week_old = strtotime('-1 week')),
                    'name' => $this->l('1 week old') . ' ' . $this->getFilesByTime($one_week_old),
                ),
                'one_month_old' => array(
                    'id_option' => 'one_month_old',
                    'value' => ($one_month_old = strtotime('-1 month')),
                    'name' => $this->l('1 month old') . ' ' . $this->getFilesByTime($one_month_old),
                ),
                'six_month_old' => array(
                    'id_option' => 'six_month_old',
                    'value' => ($six_month_old = strtotime('-6 month')),
                    'name' => $this->l('6 months old') . ' ' . $this->getFilesByTime($six_month_old),
                ),
                'one_year_old' => array(
                    'id_option' => 'one_year_old',
                    'value' => ($one_year_old = strtotime('-6 month')),
                    'name' => $this->l('1 year old') . ' ' . $this->getFilesByTime($one_year_old),
                ),
            );
        }

        return $option !== null ? (isset(self::$cache_options_time[$option]) ? self::$cache_options_time[$option] : false) : self::$cache_options_time;
    }

    public function getFilesByTime($time = 0)
    {
        $count = 0;
        $filesize = 0;
        if (is_dir(self::$default_upload)) {
            $files = HDTools::getRecursiveFiles(self::$default_upload, $files, $time);
            if ($files) {
                foreach ($files as $file) {
                    $filesize += $file['size'];
                    $count++;
                }
            }
        }
        if ($count) {
            return sprintf($this->l('(%d files - %s)'), $count, HDTools::formatBytes($filesize));
        }
    }

    static $cache_status_reply;

    public function getStatusReply($option = null)
    {
        if (!self::$cache_status_reply) {
            self::$cache_status_reply = array(
                '0' => array(
                    'id' => '0',
                    'name' => $this->l('Wait for reply'),
                    'icon' => $this->getSVGFonts('reply', 'wait-for-reply')
                ),
                '1' => array(
                    'id' => '1',
                    'name' => $this->l('Replied'),
                    'icon' => $this->getSVGFonts('reply', 'replied')
                ),
            );
        }

        return $option !== null ? (isset(self::$cache_status_reply[$option]) ? self::$cache_status_reply[$option] : false) : self::$cache_status_reply;
    }

    static $cache_options_priority = array();

    public function getOptionPriority($option = null)
    {
        if (!self::$cache_options_priority) {
            self::$cache_options_priority = array(
                'low' => array(
                    'id' => 'low',
                    'name' => $this->l('Low')
                ),
                'medium' => array(
                    'id' => 'medium',
                    'name' => $this->l('Medium')
                ),
                'high' => array(
                    'id' => 'high',
                    'name' => $this->l('High')
                ),
                'urgent' => array(
                    'id' => 'urgent',
                    'name' => $this->l('Urgent')
                ),
            );
        }

        return $option !== null ? (isset(self::$cache_options_priority[$option]) ? self::$cache_options_priority[$option] : false) : self::$cache_options_priority;
    }

    static $cache_options_status = array();

    public function getOptionStatus($option = null)
    {
        if (!self::$cache_options_status) {
            self::$cache_options_status = array(
                'open' => array(
                    'id' => 'open',
                    'name' => $this->l('Open')
                ),
                'closed' => array(
                    'id' => 'closed',
                    'name' => $this->l('Closed')
                ),
                'canceled' => array(
                    'id' => 'canceled',
                    'name' => $this->l('Canceled')
                ),
            );
        }

        return $option !== null ? (isset(self::$cache_options_status[$option]) ? self::$cache_options_status[$option] : false) : self::$cache_options_status;
    }

    public function getQuickTabs()
    {
        if (!self::$_quickTabs) {
            self::$_quickTabs = array(
                'dashboard' => array(
                    'label' => $this->l('Dashboard'),
                    'origin' => 'Dashboard',
                    'icon' => 'dashboard',
                    'class' => 'Dashboard',
                ),
                'tickets' => array(
                    'label' => $this->l('Tickets'),
                    'origin' => 'Tickets',
                    'icon' => 'tickets',
                    'class' => 'Tickets',
                ),
                'staffs' => array(
                    'label' => $this->l('Staffs'),
                    'origin' => 'Staffs',
                    'icon' => 'staffs',
                    'class' => 'Staffs',
                ),
                'settings' => array(
                    'label' => $this->l('Settings'),
                    'origin' => 'Settings',
                    'icon' => 'settings',
                    'class' => 'Settings',
                ),
                'download' => array(
                    'label' => $this->l('Download'),
                    'origin' => 'Download',
                    'icon' => 'download',
                    'class' => 'Download',
                    'active' => 0,
                ),
                'process' => array(
                    'label' => $this->l('Process'),
                    'origin' => 'Process',
                    'icon' => 'process',
                    'class' => 'Process',
                    'active' => 0,
                ),
                'cronjob' => array(
                    'label' => $this->l('Cronjob'),
                    'origin' => 'Cronjob',
                    'icon' => 'cronjob',
                    'class' => 'Cronjob',
                ),
                'mailtracking' => array(
                    'label' => $this->l('Mail tracking'),
                    'origin' => 'Mail tracking',
                    'icon' => 'mail-tracking',
                    'class' => 'MailTracking',
                ),
                'mailqueue' => array(
                    'label' => $this->l('Mail Queue'),
                    'origin' => 'Mail Queue',
                    'icon' => 'mail-queue',
                    'class' => 'MailQueue',
                ),
                'maillog' => array(
                    'label' => $this->l('Mail log'),
                    'origin' => 'Mail log',
                    'icon' => 'mail-log',
                    'class' => 'MailLog',
                ),
            );
        }
        return self::$_quickTabs;
    }

    static $cache_field_ticket = array();

    public function getTicketFields()
    {
        if (!self::$cache_field_ticket) {
            self::$cache_field_ticket = array(
                'id_ets_hd_ticket' => array(
                    'name' => 'id_ets_hd_ticket',
                    'type' => 'hidden',
                    'label' => $this->l('Ticket ID'),
                    'default' => 0,
                    'validate' => 'isUnsignedInt'
                ),
                'id_product' => array(
                    'name' => 'id_product',
                    'type' => 'hidden',
                    'label' => $this->l('Product'),
                    'default' => 0,
                    'validate' => 'isUnsignedInt'
                ),
                'order_ref' => array(
                    'name' => 'order_ref',
                    'type' => 'hidden',
                    'label' => $this->l('Order ref'),
                    'validate' => 'isReference'
                ),
            );
        }

        return self::$cache_field_ticket;
    }

    static $cache_field_message;

    public function getMessageFields()
    {
        if (!self::$cache_field_message) {
            self::$cache_field_message = array(
                'message' => array(
                    'name' => 'message',
                    'type' => 'textarea',
                    'label' => $this->l('Message'),
                    'required' => true,
                    'validate' => 'isCleanHtml'
                ),
                'attachment' => array(
                    'name' => 'attachment',
                    'type' => 'file',
                    'label' => $this->l('Attachment'),
                    'attachment' => true,
                    'folder' => self::$default_upload
                )
            );
        }

        return self::$cache_field_message;
    }

    static $cache_field_cronjob = array();

    public function getConfigsCronjob()
    {
        if (!self::$cache_field_cronjob) {
            self::$cache_field_cronjob = array(
                'ETS_HD_CRONJOB_SECURE_TOKEN' => array(
                    'name' => 'ETS_HD_CRONJOB_SECURE_TOKEN',
                    'label' => $this->l('Cronjob secure token'),
                    'type' => 'text',
                    'default' => Tools::passwdGen(10),
                    'required' => true,
                    'global' => true,
                    'group' => 'config',
                ),
                'ETS_HD_CRONJOB_EMAILS' => array(
                    'name'=>'ETS_HD_CRONJOB_EMAILS',
                    'type' => 'text',
                    'label' => $this->l('Mail queue step') . ' (' . $this->l('Maximum number of emails sent every time cronjob file run') . ')',
                    'default' => 5,
                    'col' => 3,
                    'suffix' => $this->l('email(s)'),
                    'required' => true,
                    'global' => 1,
                    'validate' => 'isUnsignedInt',
                    'tab' => 'general',
                    'desc' => $this->l('Every time cronjob is run, it will check mail queue for the emails to be sent. Reduce this value if your server has limited timeout.')
                ),
                'ETS_HD_CRONJOB_MAX_TRY' => array(
                    'name' => 'ETS_HD_CRONJOB_MAX_TRY',
                    'type' => 'text',
                    'label' => $this->l('Mail queue max-trying times'),
                    'default' => 5,
                    'col' => 3,
                    'suffix' => $this->l('time(s)'),
                    'required' => true,
                    'global' => 1,
                    'validate' => 'isUnsignedInt',
                    'tab' => 'general',
                    'desc' => $this->l('The times to try to send an email again if it was failed! After that, the email will be deleted from queue.'),
                ),
                'ETS_HD_ENABLED_LOG_MAIL' => array(
                    'type' => 'switch',
                    'name' => 'ETS_HD_ENABLED_LOG_MAIL',
                    'label' => $this->l('Enable mail log'),
                    'default' => 1,
                    'validate' => 'isUnsignedInt',
                    'tab' => 'general',
                    'values' => array(
                        array(
                            'label' => $this->l('Yes'),
                            'id' => 'ETS_HD_ENABLED_LOG_MAIL_on',
                            'value' => 1,
                        ),
                        array(
                            'label' => $this->l('No'),
                            'id' => 'ETS_HD_ENABLED_LOG_MAIL_off',
                            'value' => 0,
                        )
                    ),
                ),
                'ETS_HD_SAVE_CRONJOB_LOG' => array(
                    'name' => 'ETS_HD_SAVE_CRONJOB_LOG',
                    'label' => $this->l('Save cronjob log'),
                    'type' => 'switch',
                    'default' => 1,
                    'desc' => $this->l('Only recommended for debug purpose'),
                    'global' => true,
                    'group' => 'log',
                ),
                'ETS_HD_CRONJOB_LOG' => array(
                    'name' => 'ETS_HD_CRONJOB_LOG',
                    'label' => $this->l('Cronjob log'),
                    'type' => 'textarea',
                    'autosize' => false,
                    'global' => true,
                    'readonly' => true,
                    'rows' => 10,
                    'group' => 'log',
                ),
            );
        }
        return self::$cache_field_cronjob;
    }

    static $cache_field_type = array();

    public function getConfigsFieldType($type = null)
    {
        if (!self::$cache_field_type) {
            self::$cache_field_type = array(
                'int' => array(
                    'id' => 'int',
                    'name' => $this->l('INT'),
                    'validate' => 'isUnsignedInt',
                    'default' => '11'
                ),
                'tinyint' => array(
                    'id' => 'tinyint',
                    'name' => $this->l('TINYINT'),
                    'validate' => 'isUnsignedInt',
                    'default' => '1'
                ),
                'decimal' => array(
                    'id' => 'decimal',
                    'name' => $this->l('DECIMAL'),
                    'validate' => 'isUnsignedFloat',
                    'default' => '20,6'
                ),
                'char' => array(
                    'id' => 'char',
                    'name' => $this->l('CHAR'),
                    'validate' => 'isCleanHtml',
                    'default' => '255'
                ),
                'varchar' => array(
                    'id' => 'varchar',
                    'name' => $this->l('VARCHAR'),
                    'validate' => 'isCleanHtml',
                    'default' => '255'
                ),
                'text' => array(
                    'id' => 'text',
                    'name' => $this->l('TEXT'),
                    'validate' => 'isCleanHtml',
                ),
                'mediumtext' => array(
                    'id' => 'mediumtext',
                    'name' => $this->l('MEDIUMTEXT'),
                    'validate' => 'isCleanHtml',
                ),
                'longtext' => array(
                    'id' => 'longtext',
                    'name' => $this->l('LONGTEXT'),
                    'validate' => 'isCleanHtml',
                ),
                'date' => array(
                    'id' => 'date',
                    'name' => $this->l('DATE'),
                    'validate' => 'isDate',
                ),
                'datetime' => array(
                    'id' => 'datetime',
                    'name' => $this->l('DATETIME'),
                    'validate' => 'isDate',
                )
            );
        }

        return $type !== null ? (isset(self::$cache_field_type[$type]) ? self::$cache_field_type[$type] : array()) : self::$cache_field_type;
    }

    static $cache_fonts = array();

    public function getSVGFonts($font, $class = null)
    {
        if (!isset(self::$cache_fonts[$font])) {
            $context = Context::getContext();
            $tpl_vars = array('font' => $font);
            if (null !== $class) {
                $tpl_vars['class'] = $class;
            }
            $context->smarty->assign($tpl_vars);
            self::$cache_fonts[$font] = $context->smarty->fetch(dirname(__FILE__) . '/../views/templates/hook/bo-fo-font-svg.tpl');
        }

        return self::$cache_fonts[$font];
    }
}